<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: sans-serif;
            font-size: 11px;
            margin: 0;
            padding: 0;
        }
        .center {
            text-align: center;
        }
        .bold {
            font-weight: bold;
        }
        .line {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
        .logo {
            width: 70px;
            height: auto;
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="center">
        <?php if($instituto && $instituto->logo): ?>
            <img src="<?php echo e(public_path('storage/' . $instituto->logo)); ?>" alt="Logo" class="logo">
        <?php endif; ?>
        <div class="bold"><?php echo e($instituto->nombre ?? 'INSTITUTO'); ?></div>
        <div><?php echo e($instituto->direccion ?? ''); ?></div>
        <div>Tel: <?php echo e($instituto->telefono ?? ''); ?></div>
        <div>Cod. Modular: <?php echo e($instituto->codigo_modular ?? ''); ?></div>
        <div>Dre: <?php echo e($instituto->dre ?? ''); ?></div>
        
        <div class="line"></div>
        <div class="bold">COMPROBANTE DE TRANSACCIÓN</div>
    </div>

    <div class="line"></div>
    <div><strong>Fecha:</strong> <?php echo e(\Carbon\Carbon::parse($transaccion->fecha)->format('d/m/Y')); ?></div>
    <div><strong>Tipo:</strong> <?php echo e(ucfirst($transaccion->tipo)); ?></div>
    <div><strong>Concepto:</strong> <?php echo e($transaccion->concepto->nombre ?? '-'); ?></div>
    <div><strong>Monto:</strong> S/ <?php echo e(number_format($transaccion->monto, 2)); ?></div>
    <div><strong>Estado:</strong> <?php echo e(ucfirst($transaccion->estado)); ?></div>

    <div class="line"></div>
    <div><strong>DNI:</strong> <?php echo e($transaccion->dni ?? '-'); ?></div>
    <div><strong>Apellidos:</strong> <?php echo e($transaccion->apellidos ?? '-'); ?></div>
    <div><strong>Nombres:</strong> <?php echo e($transaccion->nombres ?? '-'); ?></div>
    <div><strong>Caja:</strong> <?php echo e($transaccion->caja->nombre ?? '-'); ?></div>

    <div class="line"></div>
    <div><strong>Obs:</strong> <?php echo e($transaccion->observacion ?? '---'); ?></div>
    <div class="line"></div>

    <div class="center">Gracias por su pago</div>
</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/transacciones/ticket.blade.php ENDPATH**/ ?>