<?php

namespace App\Exports;

use App\Models\Inscripcion;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class InscripcionesEstadoExport implements FromCollection, WithHeadings
{
    protected $estado;

    public function __construct($estado)
    {
        $this->estado = $estado;
    }

    public function collection()
    {
        return Inscripcion::with(['postulante', 'plan', 'admision'])
            ->where('estado', $this->estado)
            ->get()
            ->map(function($i){
                return [
                    'ID'         => $i->id_inscripcion,
                    'Postulante' => $i->postulante->nombres.' '.$i->postulante->apellidos,
                    'DNI'        => $i->postulante->dni,
                    'Programa'   => $i->plan->nombre ?? '',
                    'Admision'   => $i->admision->nombre ?? '',
                    'Estado'     => $i->estado,
                    'Fecha'      => $i->created_at ? $i->created_at->format('d/m/Y') : '',
                ];
            });
    }

    public function headings(): array
    {
        return [
            'ID',
            'Postulante',
            'DNI',
            'Programa',
            'Admisión',
            'Estado',
            'Fecha Registro'
        ];
    }
}
