<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ArchivoCurso extends Model
{
    use HasFactory;

    protected $table = 'archivos_curso';

    protected $fillable = [
        'curso_id',
        'sesion_id', // agregado
        'tipo',
        'nombre',
        'ruta',
        'fecha_subida',
    ];

    public $timestamps = true;

    protected $casts = [
        'fecha_subida' => 'datetime',
    ];

    // Relación con Curso
    public function curso()
    {
        return $this->belongsTo(Curso::class, 'curso_id');
    }

    // Relación con Sesión
    public function sesion()
    {
        return $this->belongsTo(Sesion::class, 'sesion_id');
    }
}
