<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ModuloRole extends Model
{
    use HasFactory;

    protected $table = 'modulo_roles';

    protected $fillable = [
        'modulo_id',
        'rol_id',
    ];

    /**
     * Relación con el módulo.
     */
    public function modulo()
    {
        return $this->belongsTo(Modulo::class, 'modulo_id');
    }

    /**
     * Relación con el rol.
     */
    public function rol()
    {
        return $this->belongsTo(Role::class, 'rol_id');
    }
}
