<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RequisitoTramite extends Model
{
    // Nombre explícito de la tabla si no sigue la convención plural
    protected $table = 'requisitos_tramite';

    // Clave primaria diferente a "id"
    protected $primaryKey = 'id';

    // Si usas timestamps (created_at, updated_at)
    public $timestamps = true;

    // Campos que se pueden asignar masivamente
    protected $fillable = [
        'descripcion',
        'estado',
        'fecha_registro',
        'fecha_actualizacion',
    ];

    // Relación muchos a muchos inversa con Tramite (si quieres acceder desde requisito a trámites)
    public function tramites()
    {
        return $this->belongsToMany(
            Tramite::class,       // Modelo relacionado
            'tramite_requisitos', // Tabla pivote
            'requisito_id',       // FK en pivote hacia este modelo
            'tramite_id'          // FK en pivote hacia el modelo relacionado
        )->withTimestamps();
    }
}
