<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ResultadoAdmision extends Model
{
    protected $table = 'resultados_admision';
    protected $primaryKey = 'id';

    protected $fillable = [
        'postulante_id',
        'plan_estudio_id',
        'nota',
        'estado',
        'id_proceso',
    ];

    /* ========================
       RELACIONES
    ======================== */

    // Relación con postulantes
    public function postulante()
    {
        return $this->belongsTo(Postulante::class, 'postulante_id', 'id_postulante');
    }

    // Relación con planes de estudio
    public function planEstudio()
    {
        return $this->belongsTo(PlanEstudio::class, 'plan_estudio_id', 'id');
    }

    // Relación con admisiones
    public function admision()
    {
        return $this->belongsTo(Admision::class, 'id_proceso', 'id_admision');
    }
}
