<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SolicitudTramite extends Model
{
    use HasFactory;

    protected $table = 'solicitudes_tramites';

    protected $fillable = [
        'postulante_id',
        'tramite_id',
        'area_id',
        'estado',
        'fecha_solicitud',
        'fecha_resolucion',
        'motivo_rechazo',
        'prioridad',
        'archivo',
    ];

    // Relaciones
    public function postulante()
    {
        return $this->belongsTo(Postulante::class, 'postulante_id');
    }

    public function tramite()
    {
        return $this->belongsTo(Tramite::class, 'tramite_id');
    }

    public function area()
    {
        return $this->belongsTo(Area::class, 'area_id');
    }

    public function historial()
    {
        return $this->hasMany(HistorialDerivacion::class, 'solicitud_id');
    }
}
