@forelse ($cursos as $curso)
    <tr>
        <td>{{ $curso->id }}</td>
        <td>{{ $curso->nombre }}</td>
        <td>{{ $curso->tipo }}</td>
        <td>{{ $curso->modulo->nombre ?? 'Sin asignar' }}</td>
        <td>
            @foreach ($curso->cursosPlanEstudios as $rel)
                <span class="badge bg-primary">{{ $rel->planEstudio->nombre }}</span>
            @endforeach
        </td>
        <td>{{ $curso->semestre->nombre ?? 'Sin asignar' }}</td>
        <td>{{ $curso->creditos }}</td>
        <td>{{ $curso->horas_semestrales }}</td>
        <td>
            <a href="{{ route('cursos.edit', $curso->id) }}" class="text-warning">
                <i class="las la-pen text-secondary font-18"></i>
            </a>
            <form action="{{ route('cursos.destroy', $curso->id) }}" method="POST" class="d-inline delete-form">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-link p-0" onclick="return confirm('¿Deseas eliminar este curso?')">
                    <i class="las la-trash-alt text-secondary font-18"></i>
                </button>
            </form>
        </td>
    </tr>
@empty
    <tr>
        <td colspan="9" class="text-center">No se encontraron cursos.</td>
    </tr>
@endforelse
