@extends('layouts.master')
@section('title') Perfil Estudiante @endsection

@section('content')
@component('components.breadcrumb')
    @slot('li_1') Inicio @endslot
    @slot('li_2') Panel Estudiante @endslot
    @slot('title') Perfil del Estudiante @endslot
@endcomponent

<div class="row">
    <div class="col-12">
        <div class="card shadow-sm border-0 mb-4">
            <!-- Encabezado limpio -->
            <div class="card-header bg-white border-bottom">
                <h5 class="mb-0 text-primary fw-semibold">Ficha de Presentación del Estudiante</h5>
            </div>

            <div class="card-body">
                <div class="row g-4">
                    <!-- Columna Izquierda: Perfil -->
                    <div class="col-lg-4 text-center">
                        <img src="{{ $postulante->foto_postulante ? asset($postulante->foto_postulante) : asset('assets/images/users/avatar-1.jpg') }}"
                             class="img-fluid rounded-circle border border-3 shadow-sm mb-3"
                             width="130" alt="Foto del estudiante">

                        <h5 class="mb-1">{{ $postulante->nombres }} {{ $postulante->apellidos }}</h5>
                        <p class="text-muted mb-1">Código: <strong>{{ $postulante->codigo_postulante }}</strong></p>
                        <p class="text-muted mb-1">Email: <strong>{{ $postulante->email }}</strong></p>
                        <p class="text-muted mb-3">Teléfono: <strong>{{ $postulante->telefono }}</strong></p>

                        <!-- Botón de acción discreto -->
                        <a href="{{ route('estudiantes.perfil') }}" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-edit me-1"></i> Editar Perfil
                        </a>
                    </div>

                    <!-- Columna Derecha: Información -->
                    <div class="col-lg-8">
                        <!-- Datos Personales -->
                        <div class="mb-4">
                            <h6 class="text-primary border-start border-4 ps-2 mb-3">Datos Personales</h6>
                            <div class="row">
                                @php
                                    $personales = [
                                        'DNI' => $postulante->dni,
                                        'Género' => $postulante->genero,
                                        'Fecha de Nacimiento' => $postulante->fecha_nacimiento,
                                        'Lengua Materna' => $postulante->lengua_materna,
                                        'Dirección' => $postulante->direccion,
                                        'Discapacidad' => $postulante->discapacidad ? 'Sí' : 'No',
                                        'Tipo de Discapacidad' => $postulante->discapacidad ? $postulante->nombre_discapacidad : null,
                                    ];
                                @endphp

                                @foreach($personales as $label => $value)
                                    @if($value)
                                        <div class="col-md-6 mb-2">
                                            <strong>{{ $label }}:</strong> {{ $value }}
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>

                        <!-- Información Académica -->
                        <div class="mb-4">
                            <h6 class="text-primary border-start border-4 ps-2 mb-3">Información Académica</h6>
                            <div class="row">
                                @php
                                    $academica = [
                                        'Colegio' => $postulante->colegio->nombre ?? 'No registrado',
                                        'Año de Egreso' => $postulante->año_egreso,
                                        'Fuente de Inscripción' => $postulante->fuente_inscripcion,
                                        'Grado' => $postulante->grado,
                                        
                                    ];
                                @endphp

                                @foreach($academica as $label => $value)
                                    @if($value)
                                        <div class="col-md-6 mb-2">
                                            <strong>{{ $label }}:</strong> {{ $value }}
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>

                        <!-- Documentos Subidos -->
                        <div>
                            <h6 class="text-primary border-start border-4 ps-2 mb-3">Documentos Subidos</h6>
                            <div class="row g-3">
                                @foreach([
                                    'Certificado de Estudios' => $postulante->certificado_estudios,
                                    'Partida de Nacimiento' => $postulante->partida_nacimiento,
                                    'Comprobante de Pago' => $postulante->comprobante_pago,
                                    'Copia de DNI' => $postulante->copia_dni,
                                    'Currículum Vitae' => $postulante->curriculum_archivo,
                                ] as $nombre => $archivo)
                                    <div class="col-md-6">
                                        <div class="border rounded p-3 d-flex justify-content-between align-items-center">
                                            <span class="fw-semibold">{{ $nombre }}</span>
                                            @if($archivo)
                                                <a href="{{ asset($archivo) }}" class="text-success text-decoration-none small" target="_blank">
                                                    Ver documento <i class="fas fa-file-alt ms-1"></i>
                                                </a>
                                            @else
                                                <span class="text-muted small">No registrado</span>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>


                    </div> <!-- /col-lg-8 -->
                </div> <!-- /row -->
            </div> <!-- /card-body -->
        </div>
    </div>
</div>





@endsection
