<div class="table-responsive">
    <table id="tablaPeriodos" class="table table-striped table-hover">
        <thead class="table-light">
            <tr>
                <th>Código Matrícula</th>
                <th>Postulante</th>
                <th>Plan de Estudio</th>
                <th>Periodo</th>
                <th>Semestre</th>
                <th>Estado</th>
                <th>Fecha Matrícula</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($matriculas as $matricula)
                <tr>
                    <td>{{ $matricula->codigo_matricula }}</td>
                    <td>{{ $matricula->postulante->nombres }} {{ $matricula->postulante->apellidos }}</td>
                    <td>{{ $matricula->planEstudio->nombre }}</td>
                    <td>{{ $matricula->periodo->nombre }}</td>
                    <td>{{ $matricula->semestre->nombre }}</td>
                    <td>
                        @php
                            $estados = [
                                'Matriculado' => 'success',
                                'Pendiente' => 'warning',
                                'Retirado' => 'danger',
                                'Convalidado' => 'info',
                                'Repitencia' => 'secondary',
                            ];
                        @endphp
                        <span class="badge bg-{{ $estados[$matricula->estado] ?? 'dark' }}">{{ $matricula->estado }}</span>
                    </td>
                    <td>{{ \Carbon\Carbon::parse($matricula->fecha_matricula)->format('d/m/Y') }}</td>
                    <td>
                        

                        <a href="#" class="btn-editar-matricula" data-bs-toggle="modal" data-bs-target="#editModal"
                            data-id="{{ $matricula->id }}"
                            data-codigo="{{ $matricula->codigo_matricula }}"
                            data-postulante="{{ $matricula->postulante_id }}"
                            data-plan="{{ $matricula->plan_estudio_id }}"
                            data-periodo="{{ $matricula->periodo_id }}"
                            data-semestre="{{ $matricula->semestre_id }}"
                            data-estado="{{ $matricula->estado }}"
                            data-fecha="{{ $matricula->fecha_matricula }}">
                            <i class="las la-pen text-secondary font-18"></i>
                        </a>

                        <a href="#" class="text-danger btn-eliminar-matricula" data-id="{{ $matricula->id }}">
                            <i class="las la-trash-alt text-secondary font-18"></i>
                        </a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
