@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Plan de Estudio - Periodo @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <div class="table-responsive">
                    <table id="tablaPlanesEstudio" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Código</th>
                                <th>Resolución</th>
                                <th>Tipo</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($planesEstudio as $planEstudio)
                                <tr>
                                    <td>{{ $planEstudio->id }}</td>
                                    <td>{{ $planEstudio->nombre }}</td>
                                    <td>{{ $planEstudio->codigo }}</td>
                                    <td>{{ $planEstudio->resolucion }}</td>
                                    <td>{{ $planEstudio->tipo }}</td>
                                    <td>
                                        @if ($planEstudio->activo)
                                            <span class="badge badge-soft-success">Activo</span>
                                        @else
                                            <span class="badge badge-soft-warning">Inactivo</span>
                                        @endif
                                    </td>
                                    <td>
                                        <!-- Icono de editar -->
                                        <a href="#" 
                                            class="text-warning"
                                            data-bs-toggle="modal" 
                                            data-bs-target="#editModal"
                                            data-id="{{ $planEstudio->id }}"
                                            data-nombre="{{ $planEstudio->nombre }}"
                                            data-codigo="{{ $planEstudio->codigo }}"
                                            data-resolucion="{{ $planEstudio->resolucion }}"
                                            data-tipo="{{ $planEstudio->tipo }}"
                                            data-activo="{{ $planEstudio->activo }}"
                                            data-descripcion="{{ $planEstudio->descripcion }}">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>

                                        <form action="#" method="POST" style="display:inline;" class="form-eliminar" data-id="{{ $planEstudio->id }}">
                                            @csrf
                                            @method('DELETE')
                                            <a href="#" class="text-danger btn-eliminar">
                                                <i class="las la-trash-alt text-secondary font-18"></i>
                                            </a>
                                        </form>

                                        
                                        

                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>



                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal para agregar un nuevo Plan de Estudio -->
<div class="modal fade" id="modalNuevoPlanEstudio" tabindex="-1" aria-labelledby="modalNuevoPlanEstudioLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalNuevoPlanEstudioLabel">Agregar Nuevo Plan de Estudio</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <!-- Formulario para crear el nuevo Plan de Estudio -->
                <form id="formNuevoPlanEstudio">
                    @csrf

                    <!-- Campo Nombre Plan de Estudio -->
                    <div class="mb-3">
                        <label for="nombrePlanEstudio" class="form-label">Nombre del Plan de Estudio</label>
                        <input type="text" class="form-control" id="nombrePlanEstudio" name="nombre" required>
                    </div>

                    <!-- Campo Descripción -->
                    <div class="mb-3">
                        <label for="descripcionPlanEstudio" class="form-label">Descripción</label>
                        <textarea class="form-control" id="descripcionPlanEstudio" name="descripcion" rows="3"></textarea>
                    </div>

                    <!-- Campo Código -->
                    <div class="mb-3">
                        <label for="codigoPlanEstudio" class="form-label">Código</label>
                        <input type="text" class="form-control" id="codigoPlanEstudio" name="codigo" required>
                    </div>

                    <!-- Campo Resolución -->
                    <div class="mb-3">
                        <label for="resolucionPlanEstudio" class="form-label">Resolución</label>
                        <input type="text" class="form-control" id="resolucionPlanEstudio" name="resolucion" required>
                    </div>

                    <!-- Campo Tipo -->
                    <div class="mb-3">
                        <label for="tipoPlanEstudio" class="form-label">Tipo</label>
                        <select class="form-select" id="tipoPlanEstudio" name="tipo" required>
                            <option value="">-- Seleccionar --</option>
                            <option value="Modular">Modular</option>
                            <option value="Transversal">Transversal</option>
                            <option value="Empleabilidad">Empleabilidad</option>
                        </select>
                    </div>

                    <!-- Campo Activo -->
                    <div class="mb-3">
                        <label for="activo" class="form-label">Estado</label>
                        <select class="form-select" id="activo" name="activo" required>
                            <option value="1">Activo</option>
                            <option value="0">Inactivo</option>
                        </select>
                    </div>

                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-de-primary btn-sm px-4">Guardar Plan de Estudio</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>







<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPlanesEstudio").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPlanesEstudio_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $(document).ready(function() {
        $('#formNuevoPlanEstudio').on('submit', function(e) {
            e.preventDefault(); // Evitar que el formulario se envíe de manera tradicional

            // Obtener los datos del formulario
            var formData = $(this).serialize();

            // Enviar la solicitud AJAX
            $.ajax({
                url: '{{ route('planes_estudio.store') }}', // Asegúrate de que la ruta sea correcta
                type: 'POST',
                data: formData,
                success: function(response) {
                    // Si la respuesta es exitosa, muestra la alerta
                    Swal.fire({
                        icon: 'success',
                        title: '¡Plan de Estudio creado!',
                        text: response.message, // Aquí puedes personalizar el mensaje de éxito
                        showConfirmButton: true,
                    }).then(() => {
                        // Cierra el modal y actualiza la página
                        $('#modalNuevoPlanEstudio').modal('hide');
                        location.reload(); // O puedes actualizar la vista de alguna otra forma
                    });
                },
                error: function(xhr, status, error) {
                    // Si ocurre un error, muestra una alerta de error
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Hubo un error al crear el plan de estudio. Por favor, intentalo de nuevo.',
                        showConfirmButton: true,
                    });
                }
            });
        });
    });

</script>



<script>
    // Eliminar plan de estudio con AJAX
    $('.btn-eliminar').on('click', function (e) {
        e.preventDefault();

        var form = $(this).closest('form');
        var planId = form.data('id');

        Swal.fire({
            title: '¿Estás seguro de eliminar este plan de estudio?',
            text: "¡Esta acción no se puede deshacer!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '/planes_estudio/' + planId,
                    method: 'DELETE',
                    data: form.serialize(),
                    success: function (response) {
                        Swal.fire(
                            'Eliminado!',
                            'El plan de estudio ha sido eliminado.',
                            'success'
                        );
                        setTimeout(function () {
                            location.reload(); // Recarga la página después de la eliminación
                        }, 1500);
                    },
                    error: function () {
                        Swal.fire(
                            'Error!',
                            'Hubo un problema al eliminar el plan de estudio.',
                            'error'
                        );
                    }
                });
            }
        });
    });

    
</script>

@endsection
