<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Administrador <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Areas <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                 <div class="card shadow rounded-3">
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="rolSelect" class="form-label">Selecciona un Rol</label>
                            <select id="rolSelect" class="form-select">
                                <option value="" disabled selected>-- Seleccione un rol --</option>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($rol->id); ?>"><?php echo e($rol->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div id="modulosContainer" class="d-none">
                            <h5 class="mt-4 mb-3">Módulos disponibles</h5>
                            <form id="moduloForm">
                                <input type="hidden" name="rol_id" id="rol_id">
                                <div class="row">
                                    <?php $__currentLoopData = $modulos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modulo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-6">
                                            <div class="form-check form-switch mb-2">
                                                <input class="form-check-input modulo-switch" type="checkbox" name="modulo_ids[]" value="<?php echo e($modulo->id); ?>" id="modulo_<?php echo e($modulo->id); ?>">
                                                <label class="form-check-label" for="modulo_<?php echo e($modulo->id); ?>"><?php echo e($modulo->nombre); ?></label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <button type="submit" class="btn btn-primary mt-3">Guardar Asignación</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>






<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const rolSelect = document.getElementById('rolSelect');
        const modulosContainer = document.getElementById('modulosContainer');
        const rolIdInput = document.getElementById('rol_id');
        const moduloForm = document.getElementById('moduloForm');

        rolSelect.addEventListener('change', function () {
            const rolId = this.value;
            rolIdInput.value = rolId;

            // Limpiar switches
            document.querySelectorAll('.modulo-switch').forEach(s => s.checked = false);

            fetch(`/admin/modulo-roles/${rolId}`)
                .then(response => response.json())
                .then(data => {
                    // Marcar switches asignados
                    data.forEach(id => {
                        const checkbox = document.getElementById('modulo_' + id);
                        if (checkbox) checkbox.checked = true;
                    });
                    modulosContainer.classList.remove('d-none');
                });
        });

        moduloForm.addEventListener('submit', function (e) {
            e.preventDefault();

            const formData = new FormData(moduloForm);

            fetch("<?php echo e(route('modulo-roles.asignar')); ?>", {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: formData
            })
            .then(resp => resp.json())
            .then(data => {
                if (data.success) {
                    Swal.fire('¡Éxito!', data.message, 'success');
                } else {
                    Swal.fire('Error', 'Ocurrió un problema.', 'error');
                }
            })
            .catch(() => {
                Swal.fire('Error', 'No se pudo completar la solicitud.', 'error');
            });
        });
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/admin/modulo_roles/index.blade.php ENDPATH**/ ?>