<?php
    use App\Models\Instituto;
    $instituto = Instituto::first();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Boleta de Notas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding: 20px;
            font-family: Arial, sans-serif;
            font-size: 0.85rem;
        }

        .header {
            text-align: center;
            margin-bottom: 10px;
        }

        .header h3 {
            font-size: 1.4rem;
            margin-top: 10px;
        }

        .info-table td {
            padding: 8px;
            vertical-align: middle;
        }

        .info-table {
            margin-top: 20px;
            width: 100%;
        }

        .table-container {
            margin-top: 30px;
            width: 100%;
            overflow-x: auto;
        }

        .notes-table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
            word-wrap: break-word;
            font-size: 0.75rem;
        }

        .notes-table th,
        .notes-table td {
            border: 1px solid #dee2e6;
            text-align: center;
            padding: 6px;
        }

        .notes-table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }

        .table-striped tbody tr:nth-of-type(odd) {
            background-color: #f2f2f2;
        }

        .logo-img {
            max-height: 80px;
        }

        .firma {
            margin-top: 50px;
            text-align: right;
        }
    </style>
</head>
<body>

    <div class="header">
        <img src="<?php echo e(public_path('storage/' . $instituto->logo)); ?>" class="logo-img">
    </div>

    <div class="header">
        <h2>Boleta de Notas</h2>
    </div>

    <table class="table table-bordered info-table">
        <tbody>
            <tr>
                <td><strong>Institución</strong></td>
                <td><?php echo e($instituto->nombre); ?></td>
                <td><strong>DRE</strong></td>
                <td><?php echo e($instituto->dre); ?></td>
            </tr>
            <tr>
                <td><strong>Dirección</strong></td>
                <td><?php echo e($instituto->direccion); ?></td>
                <td><strong>Teléfono</strong></td>
                <td><?php echo e($instituto->telefono); ?></td>
            </tr>
            <tr>
                <td><strong>Código Modular</strong></td>
                <td><?php echo e($instituto->codigo_modular); ?></td>
                <td><strong>Fecha de emisión</strong></td>
                <td><?php echo e(now()->format('d/m/Y')); ?></td>
            </tr>
        </tbody>
    </table>

    <table class="table table-bordered info-table">
        <tbody>
            <tr>
                <td><strong>Apellidos y Nombres</strong></td>
                <td><?php echo e($matricula->postulante->apellidos); ?> <?php echo e($matricula->postulante->nombres); ?></td>
                <td><strong>DNI</strong></td>
                <td><?php echo e($matricula->postulante->dni); ?></td>
            </tr>
            <tr>
                <td><strong>Periodo</strong></td>
                <td><?php echo e($matricula->periodo->nombre); ?></td>
                <td><strong>Plan de Estudios</strong></td>
                <td><?php echo e($matricula->planEstudio->nombre); ?></td>
            </tr>
            <tr>
                <td><strong>Semestre</strong></td>
                <td><?php echo e($matricula->semestre->nombre); ?></td>
                <td><strong>Estado de Matrícula</strong></td>
                <td><?php echo e($matricula->estado); ?></td>
            </tr>
        </tbody>
    </table>

    <div class="table-container">
        <table class="table table-bordered table-striped notes-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Curso</th>
                    <th>Créditos</th>
                    <th>Nota Final</th>
                    <th>Condición</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $matricula->matriculaCursos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $mc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $nota = $mc->notas->nota_final ?? null;
                        $condicion = is_null($nota) ? '-' : ($nota >= 11 ? 'Aprobado' : 'Desaprobado');
                    ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e($mc->curso->nombre ?? '---'); ?></td>
                        <td><?php echo e($mc->curso->creditos ?? '-'); ?></td>
                        <td><?php echo e($mc->nota_final ?? '-'); ?></td>
                        <td>
                            <?php if(is_null($mc->nota_final)): ?>
                                -
                            <?php elseif($mc->nota_final >= 13): ?>
                                Aprobado
                            <?php elseif($mc->nota_final >= 11): ?>
                                Recuperación
                            <?php else: ?>
                                Desaprobado
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <div class="firma">
        <p>__________________________</p>
        <p><strong>Firma y Sello Institucional</strong></p>
    </div>

</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/reportes/boleta_notas.blade.php ENDPATH**/ ?>