<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Reporte de Convalidaciones</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding: 20px;
            font-family: Arial, sans-serif;
            font-size: 0.85rem;
        }
        .header {
            text-align: center;
            margin-bottom: 10px;
        }
        .header h3 {
            font-size: 1.4rem;
            margin-top: 10px;
        }
        .info-table td {
            padding: 8px;
            vertical-align: middle;
        }
        .info-table {
            margin-top: 20px;
            width: 100%;
        }
        .table-container {
            margin-top: 30px;
            width: 100%;
            overflow-x: auto;
        }
        .notes-table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
            word-wrap: break-word;
            font-size: 0.75rem;
        }
        .notes-table th,
        .notes-table td {
            border: 1px solid #dee2e6;
            text-align: center;
            padding: 6px;
        }
        .notes-table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .table-striped tbody tr:nth-of-type(odd) {
            background-color: #f2f2f2;
        }
        .logo-img {
            max-height: 80px;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="<?php echo e(public_path('storage/' . $instituto->logo)); ?>" class="logo-img" alt="Logo Instituto">
    </div>

    <div class="header">
        <h1>Reporte de Convalidaciones</h1>
        <p>Reporte desde: <?php echo e($fechaInicio); ?> hasta <?php echo e($fechaFin); ?></p>



    </div>

    <table class="table table-bordered table-striped info-table">
        <tbody>
            <tr>
                <td><strong>Nombre del Instituto</strong></td>
                <td><?php echo e($instituto->nombre); ?></td>
                <td><strong>DRE</strong></td>
                <td><?php echo e($instituto->dre); ?></td>
            </tr>
            <tr>
                <td><strong>Código Modular</strong></td>
                <td><?php echo e($instituto->codigo_modular); ?></td>
                <td><strong>Departamento</strong></td>
                <td><?php echo e($instituto->departamento); ?></td>
            </tr>
            <tr>
                <td><strong>Provincia</strong></td>
                <td><?php echo e($instituto->provincia); ?></td>
                <td><strong>Distrito</strong></td>
                <td><?php echo e($instituto->distrito); ?></td>
            </tr>
        </tbody>
    </table>

    <div class="table-container">
        <table class="table table-bordered table-striped notes-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Estudiante</th>
                    <th>DNI</th>
                    <th>Curso Destino</th>
                    <th>Curso Origen</th>
                    <th>Institución Origen</th>
                    <th>Nota Origen</th>
                    <th>Fecha Convalidación</th>
                    <th>Observaciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $convalidaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $convalidacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($convalidacion->estudiante->nombres); ?> <?php echo e($convalidacion->estudiante->apellidos); ?></td>
                        <td><?php echo e($convalidacion->estudiante->dni); ?></td>
                        <td><?php echo e($convalidacion->cursoDestino->nombre ?? 'N/A'); ?></td>
                        <td><?php echo e($convalidacion->curso_origen); ?></td>
                        <td><?php echo e($convalidacion->institucion_origen); ?></td>
                        <td><?php echo e($convalidacion->nota_origen); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($convalidacion->fecha_convalidacion)->format('d/m/Y')); ?></td>
                        <td><?php echo e($convalidacion->observaciones); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if($convalidaciones->isEmpty()): ?>
                    <tr>
                        <td colspan="9">No se encontraron convalidaciones en el rango seleccionado.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/convalidaciones/reporte_pdf.blade.php ENDPATH**/ ?>