<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Medios de Pagos <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3"
                    data-bs-toggle="modal"
                    data-bs-target="#modalNuevoTipo">
                    <i class="fas fa-plus"></i> Agregar Medio de Pago
                </button>
                <div class="table-responsive">
                    
                <table id="tablaTipoPago" class="table table-striped mb-0 table-hover">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Banco o Entidad</th>
                            <th>Número de Cuenta</th>
                            <th>CCI</th>
                            <th>Titular</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $tipos_pago; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($tipo->id_tipo_pago); ?></td>
                                <td><?php echo e($tipo->nombre); ?></td>
                                <td><?php echo e($tipo->banco_o_entidad); ?></td>
                                <td><?php echo e($tipo->numero_cuenta); ?></td>
                                <td><?php echo e($tipo->cci); ?></td>
                                <td><?php echo e($tipo->nombre_titular); ?></td>
                                <td class="d-flex align-items-center gap-2">
                                    <div class="form-check form-switch m-0">
                                        <input class="form-check-input toggle-estado" type="checkbox"
                                            data-id="<?php echo e($tipo->id_tipo_pago); ?>"
                                            <?php echo e($tipo->activo ? 'checked' : ''); ?>>
                                    </div>
                                    <span class="badge <?php echo e($tipo->activo ? 'badge-soft-success' : 'badge-soft-warning'); ?>" id="estado-texto-<?php echo e($tipo->id_tipo_pago); ?>">
                                        <?php echo e($tipo->activo ? 'Activo' : 'Inactivo'); ?>

                                    </span>
                                </td>
                                <td>
                                    <!-- Botón Editar -->
                                    <a href="#" class="text-warning me-2"
                                        data-bs-toggle="modal"
                                        data-bs-target="#modalEditarTipoPago"
                                        data-id="<?php echo e($tipo->id_tipo_pago); ?>"
                                        data-nombre="<?php echo e($tipo->nombre); ?>"
                                        data-banco="<?php echo e($tipo->banco_o_entidad); ?>"
                                        data-cuenta="<?php echo e($tipo->numero_cuenta); ?>"
                                        data-cci="<?php echo e($tipo->cci); ?>"
                                        data-titular="<?php echo e($tipo->nombre_titular); ?>"
                                        data-activo="<?php echo e($tipo->activo); ?>">
                                        <i class="las la-pen text-secondary font-18"></i>
                                    </a>

                                    <!-- Botón Eliminar -->
                                    <form id="form-delete-<?php echo e($tipo->id_tipo_pago); ?>" action="<?php echo e(route('tipo-pago.destroy', $tipo->id_tipo_pago)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                    </form>
                                    <button type="button" class="btn btn-link p-0 m-0 align-baseline delete-button" data-id="<?php echo e($tipo->id_tipo_pago); ?>">
                                        <i class="las la-trash-alt text-secondary font-18"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>


                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal: Nuevo Tipo de Admisión -->
<!-- Modal Nuevo Tipo de Pago -->
<div class="modal fade" id="modalNuevoTipo" tabindex="-1" aria-labelledby="modalNuevoTipoLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content border-0">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalNuevoTipoLabel">
                    <i class="fas fa-plus-circle me-2"></i>Nuevo Medio de Pago
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <form id="formNuevoTipoPago" action="<?php echo e(route('tipo-pago.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="nombre" class="form-label">
                                <i class="fas fa-credit-card me-1 text-muted"></i> Nombre del medio de pago
                            </label>
                            <input type="text" class="form-control" name="nombre" required>
                        </div>

                        <div class="col-md-6">
                            <label for="banco_o_entidad" class="form-label">
                                <i class="fas fa-university me-1 text-muted"></i> Banco o Entidad
                            </label>
                            <input type="text" class="form-control" name="banco_o_entidad" required>
                        </div>

                        <div class="col-md-6">
                            <label for="numero_cuenta" class="form-label">
                                <i class="fas fa-file-invoice-dollar me-1 text-muted"></i> Número de Cuenta
                            </label>
                            <input type="text" class="form-control" name="numero_cuenta" required>
                        </div>

                        <div class="col-md-6">
                            <label for="cci" class="form-label">
                                <i class="fas fa-list-ol me-1 text-muted"></i> CCI
                            </label>
                            <input type="text" class="form-control" name="cci" required>
                        </div>

                        <div class="col-md-12">
                            <label for="nombre_titular" class="form-label">
                                <i class="fas fa-user me-1 text-muted"></i> Nombre del Titular
                            </label>
                            <input type="text" class="form-control" name="nombre_titular" required>
                        </div>

                        <div class="col-md-4">
                            <label for="activo" class="form-label">
                                <i class="fas fa-toggle-on me-1 text-muted"></i> Estado
                            </label>
                            <select class="form-select" name="activo" required>
                                <option value="1" selected>Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer d-flex justify-content-between">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i> Cancelar
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i> Guardar
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>



<!-- Modal Editar Tipo de Admisión -->
<div class="modal fade" id="modalEditarTipoPago" tabindex="-1" aria-labelledby="modalEditarTipoPagoLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content border-0">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalEditarTipoPagoLabel">
                    <i class="fas fa-edit me-2"></i>Editar Medio de Pago
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <form id="formEditarTipoPago" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <input type="hidden" name="id_tipo_pago" id="editar_id_tipo_pago">

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="editar_nombre" class="form-label">Nombre del medio de pago</label>
                            <input type="text" class="form-control" name="nombre" id="editar_nombre" required>
                        </div>

                        <div class="col-md-6">
                            <label for="editar_banco" class="form-label">Banco o Entidad</label>
                            <input type="text" class="form-control" name="banco_o_entidad" id="editar_banco" required>
                        </div>

                        <div class="col-md-6">
                            <label for="editar_cuenta" class="form-label">Número de Cuenta</label>
                            <input type="text" class="form-control" name="numero_cuenta" id="editar_cuenta" required>
                        </div>

                        <div class="col-md-6">
                            <label for="editar_cci" class="form-label">CCI</label>
                            <input type="text" class="form-control" name="cci" id="editar_cci" required>
                        </div>

                        <div class="col-md-12">
                            <label for="editar_titular" class="form-label">Nombre del Titular</label>
                            <input type="text" class="form-control" name="nombre_titular" id="editar_titular" required>
                        </div>
                    </div>
                </div>

                <div class="modal-footer d-flex justify-content-between">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>Actualizar
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>



<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>
<script src="<?php echo e(URL::asset('assets/plugins/tabulator/tabulator.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/tabulator/jspdf.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/tabulator/xlsx.full.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/tabulator/jspdf.plugin.autotable.js')); ?>"></script>
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- DataTables CSS -->
<script>
    $(document).ready(function () {
        $("#tablaTipoPago").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaTipoPago_wrapper .col-md-6:eq(0)');
    });
</script>
<!-- Agregar -->
<script>
    $(document).ready(function () {
        $('#formNuevoTipoPago').on('submit', function (e) {
            e.preventDefault();  // Prevenir el comportamiento por defecto del formulario
            let formData = $(this).serialize(); // Obtener los datos del formulario

            $.ajax({
                url: $(this).attr('action'),  // Usamos la URL del formulario
                type: 'POST',
                data: formData,  // Enviar los datos
                success: function (response) {
                    // Si la respuesta es exitosa, mostrar SweetAlert2
                    Swal.fire({
                        icon: 'success',
                        title: '¡Medio de Pago Guardado!',
                        text: 'El nuevo medio de pago ha sido registrado correctamente.',
                        confirmButtonText: 'Aceptar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Cerrar el modal después de éxito
                            $('#modalNuevoTipo').modal('hide');
                            // Opcionalmente, puedes recargar la tabla de medios de pago si se desea
                            location.reload();  // Recargar la página (o usa una función para actualizar solo la tabla)
                        }
                    });
                },
                error: function (xhr, status, error) {
                    // Si hay un error, mostrar un mensaje
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Hubo un problema al guardar el medio de pago. Intenta de nuevo.',
                        confirmButtonText: 'Aceptar'
                    });
                }
            });
        });
    });
</script>
<!-- editar -->
<script>
    $(document).ready(function () {
        // Mostrar datos en el modal al hacer clic en editar
        $('#modalEditarTipoPago').on('show.bs.modal', function (event) {
            const button = $(event.relatedTarget);

            // Llenar inputs del modal con los datos del botón
            $('#editar_id_tipo_pago').val(button.data('id'));
            $('#editar_nombre').val(button.data('nombre'));
            $('#editar_banco').val(button.data('banco'));
            $('#editar_cuenta').val(button.data('cuenta'));
            $('#editar_cci').val(button.data('cci'));
            $('#editar_titular').val(button.data('titular'));

            // Actualizar la acción del formulario con el ID
            const id = button.data('id');
            $('#formEditarTipoPago').attr('action', `/tipo-pago/${id}`);
        });

        // Manejar el submit por AJAX
        $('#formEditarTipoPago').on('submit', function (e) {
            e.preventDefault();

            const form = $(this);
            const actionUrl = form.attr('action');
            const formData = form.serialize();

            $.ajax({
                type: 'POST',
                url: actionUrl,
                data: formData,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Actualizado',
                        text: response.success,
                        confirmButtonColor: '#3085d6',
                        timer: 2000,
                        showConfirmButton: false
                    });

                    $('#modalEditarTipoPago').modal('hide');

                    // Recargar la tabla o los datos (puedes usar DataTables o recargar parte con AJAX)
                    setTimeout(() => {
                        location.reload(); // puedes cambiar esto por actualizar solo la fila
                    }, 1000);
                },
                error: function (xhr) {
                    let mensaje = 'Ocurrió un error al actualizar.';

                    if (xhr.responseJSON && xhr.responseJSON.errors) {
                        const errores = Object.values(xhr.responseJSON.errors).flat();
                        mensaje = errores.join('<br>');
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: mensaje,
                        confirmButtonColor: '#d33'
                    });
                }
            });
        });
    });

</script>
<!-- activar o desactivar -->
<script>
    $(document).ready(function () {
        $('.toggle-estado').on('change', function () {
            const checkbox = $(this);
            const id = checkbox.data('id');
            const estado = checkbox.is(':checked') ? 1 : 0;

            $.ajax({
                url: "<?php echo e(route('tipo-pago.cambiar-estado')); ?>",
                method: "POST",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    id: id,
                    activo: estado
                },
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Estado actualizado',
                        text: response.success,
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 2000,
                        timerProgressBar: true
                    });

                    // Actualizar badge de estado dinámicamente
                    const badge = $('#estado-texto-' + id);
                    if (estado) {
                        badge.removeClass('badge-soft-warning').addClass('badge-soft-success').text('Activo');
                    } else {
                        badge.removeClass('badge-soft-success').addClass('badge-soft-warning').text('Inactivo');
                    }
                },
                error: function () {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'No se pudo actualizar el estado.',
                        confirmButtonColor: '#d33'
                    });

                    // Revertir el checkbox al estado anterior en caso de error
                    checkbox.prop('checked', !estado);
                }
            });
        });
    });


</script>
<!-- eliminar -->
<script>
    $(document).ready(function () {
        $('.delete-button').on('click', function () {
            const id = $(this).data('id');
            const form = $('#form-delete-' + id);

            Swal.fire({
                title: '¿Estás seguro?',
                text: "¡Esta acción no se puede deshacer!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: form.attr('action'),
                        method: 'POST',
                        data: form.serialize(),
                        success: function (response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Eliminado',
                                text: response.success || 'Medio de pago eliminado correctamente.',
                                toast: true,
                                position: 'top-end',
                                showConfirmButton: false,
                                timer: 2000
                            });

                            // Eliminar la fila de la tabla
                            form.closest('tr').remove();
                        },
                        error: function () {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'No se pudo eliminar el medio de pago.',
                                confirmButtonColor: '#d33'
                            });
                        }
                    });
                }
            });
        });
    });


</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/tipo-pago/index.blade.php ENDPATH**/ ?>