<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Horario Académico</title>

    <style>
        @page { 
            size: A4 landscape; 
            margin: 28px 22px; 
        }

        body {
            font-family: DejaVu Sans, sans-serif;
            color: #1a1a1a;
            font-size: 11.5px;
        }

        /* ENCABEZADO */
        .header {
            text-align: center;
            margin-bottom: 8px;
            position: relative;
        }

        .logo {
            width: 190px;
            position: absolute;
            top: -10px;
            left: 0;
            border: 1px solid #ccc;
            padding: 3px;
            background: white;
        }

        .titulo {
            font-size: 21px;
            font-weight: bold;
            margin: 0;
            color: #003366;
            text-transform: uppercase;
        }

        .instituto-info {
            font-size: 12px;
            margin-top: 5px;
            color: #333;
            line-height: 1.3;
        }

        .subtitulo {
            font-size: 14px;
            margin: 4px 0;
            color: #444;
            font-style: italic;
        }

        /* Caja de información del estudiante */
        .info-box {
            width: 100%;
            margin: 12px 0;
            padding: 10px 15px;
            border: 1px solid #b3c6d4;
            background: #f4f8fc;
            border-radius: 6px;
            font-size: 13px;
        }

        .info-label {
            font-weight: bold;
            color: #003366;
        }

        /* TABLA */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 14px;
        }

        th {
            background: #003366;
            color: #fff;
            padding: 8px 5px;
            font-size: 12px;
            border: 1px solid #2c4967;
            text-transform: uppercase;
        }

        td {
            border: 1px solid #d0d8e0;
            padding: 7px 5px;
            text-align: center;
            vertical-align: middle;
            font-size: 11.3px;
        }

        /* Columna de horas estilizada */
        td:first-child {
            font-weight: bold;
            color: #003366;
            background: #eef3f8;
        }

        .curso-info {
            font-weight: bold;
            color: #003366;
            font-size: 12px;
            line-height: 1.1;
        }

        .aula-info {
            font-size: 10px;
            color: #555;
        }

        /* PIE */
        .footer {
            margin-top: 18px;
            text-align: right;
            font-size: 10px;
            color: #777;
        }

    </style>
</head>
<body>

    
    <?php if($instituto && $instituto->logo && file_exists(public_path('storage/' . $instituto->logo))): ?>
        <img src="<?php echo e(public_path('storage/' . $instituto->logo)); ?>" class="logo">
    <?php endif; ?>

    
    <div class="header">

        <h1 class="titulo">Horario Académico</h1>

        <?php if($instituto): ?>
            <div class="instituto-info">
                <strong><?php echo e($instituto->nombre); ?></strong><br>
                Código Modular: <?php echo e($instituto->codigo_modular); ?> |
                DRE: <?php echo e($instituto->dre); ?><br>
                Dirección: <?php echo e($instituto->direccion); ?>

            </div>
        <?php endif; ?>

        <p class="subtitulo">Instituto de Educación Superior Tecnológico</p>
    </div>

    
    <div class="info-box">
        <span class="info-label">Estudiante:</span>
        <?php echo e($estudiante->nombres); ?> <?php echo e($estudiante->apellidos); ?>

    </div>

    
    <table>
        <thead>
            <tr>
                <th>Hora</th>
                <?php $__currentLoopData = $dias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <th><?php echo e($dia); ?></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        </thead>

        <tbody>
            <?php $__currentLoopData = $horas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inicio => $fin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($inicio); ?> - <?php echo e($fin); ?></td>

                    <?php $__currentLoopData = $dias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php 
                            $data = $horariosDias[$dia][$inicio] ?? null; 
                        ?>

                        <td>
                            <?php if($data): ?>
                                <div class="curso-info"><?php echo e($data['curso']); ?></div>
                                <div class="aula-info">Aula: <?php echo e($data['aula']); ?></div>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    
    <div class="footer">
        Generado el <?php echo e(now()->format('d/m/Y H:i')); ?>

    </div>

</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/estudiantes/horario_pdf.blade.php ENDPATH**/ ?>