<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Curso <?php echo e($curso->nombre); ?> <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
            <div class="row">
                <!-- Sesiones -->
                <div class="col-md-3 mb-3">
                    <a href="<?php echo e(route('docente.sesiones.index', $curso->id)); ?>" class="card h-100 text-decoration-none text-dark">
                        <div class="card-body text-center">
                            <i class="fas fa-calendar-alt fa-2x text-info mb-2"></i>
                            <h5 class="card-title">Sesiones</h5>
                            <p class="card-text">Administra las sesiones y clases del curso.</p>
                        </div>
                    </a>
                </div>

                <!-- Asistencias -->
                <div class="col-md-3 mb-3">
                    <a href="<?php echo e(route('docente.asistencia.index', $curso->id)); ?>" class="card h-100 text-decoration-none text-dark">
                        <div class="card-body text-center">
                            <i class="fas fa-user-check fa-2x text-success mb-2"></i>
                            <h5 class="card-title">Asistencia</h5>
                            <p class="card-text">Gestiona la asistencia de los estudiantes.</p>
                        </div>
                    </a>
                </div>

                <!-- Notas -->
                <div class="col-md-3 mb-3">
                    <a href="<?php echo e(route('docente.notas.index', ['curso' => $curso->id])); ?>" class="card h-100 text-decoration-none text-dark">
                        <div class="card-body text-center">
                            <i class="fas fa-clipboard-list fa-2x text-warning mb-2"></i>
                            <h5 class="card-title">Notas</h5>
                            <p class="card-text">Consulta o registra notas finales.</p>
                        </div>
                    </a>
                </div>

                <!-- Carátula -->
                <div class="col-md-3 mb-3">
                    <a href="<?php echo e(route('docente.caratula.pdf', $curso->id)); ?>" class="card h-100 text-decoration-none text-dark" target="_blank">
                        <div class="card-body text-center">
                            <i class="fas fa-file-alt fa-2x text-primary mb-2"></i>
                            <h5 class="card-title">Carátula</h5>
                            <p class="card-text">Ver o imprimir la carátula del curso.</p>
                        </div>
                    </a>
                </div>


                <!-- Silabo -->
                <div class="col-md-3 mb-3">
                    <a href="<?php echo e(route('docente.silabos.index', $curso->id)); ?>" class="card h-100 text-decoration-none text-dark">
                        <div class="card-body text-center">
                            <i class="fas fa-book-open fa-2x text-danger mb-2"></i>
                            <h5 class="card-title">Silabo</h5>
                            <p class="card-text">Accede al silabo del curso.</p>
                        </div>
                    </a>
                </div>

                <!-- Material Didáctico -->
                <div class="col-md-3 mb-3">
                    <a href="<?php echo e(route('docente.archivos.index', $curso->id)); ?>" class="card h-100 text-decoration-none text-dark">
                        <div class="card-body text-center">
                            <i class="fas fa-folder-open fa-2x text-info mb-2"></i>
                            <h5 class="card-title">Material Didáctico</h5>
                            <p class="card-text">Consulta o sube material didáctico.</p>
                        </div>
                    </a>
                </div>

                <!-- Tareas -->
                <div class="col-md-3 mb-3">
                    <a href="<?php echo e(route('docente.tareas.index', $curso->id)); ?>" class="card h-100 text-decoration-none text-dark">
                        <div class="card-body text-center">
                            <i class="fas fa-tasks fa-2x text-warning mb-2"></i>
                            <h5 class="card-title">Tareas</h5>
                            <p class="card-text">Consulta o asigna tareas para los estudiantes.</p>
                        </div>
                    </a>
                </div>

                <!-- Evaluaciones -->
                <div class="col-md-3 mb-3">
                    <a href="#" class="card h-100 text-decoration-none text-dark">
                        <div class="card-body text-center">
                            <i class="fas fa-check-circle fa-2x text-success mb-2"></i>
                            <h5 class="card-title">Evaluaciones</h5>
                            <p class="card-text">Administra las evaluaciones del curso.</p>
                        </div>
                    </a>
                </div>

                <!-- Ranking -->
                <div class="col-md-3 mb-3">
                    <a href="<?php echo e(route('reporte.curso.ranking', ['curso' => $curso->id])); ?>" class="card h-100 text-decoration-none text-dark" target="_blank">
                        <div class="card-body text-center">
                            <i class="fas fa-trophy fa-2x text-primary mb-2"></i>
                            <h5 class="card-title">Ranking</h5>
                            <p class="card-text">Consulta el ranking de los estudiantes.</p>
                        </div>
                    </a>
                </div>


                <!-- Nómina -->
                <div class="col-md-3 mb-3">
                    <a href="<?php echo e(route('reporte.curso.nomina', ['curso' => $curso->id])); ?>" class="card h-100 text-decoration-none text-dark" target="_blank">
                        <div class="card-body text-center">
                            <i class="fas fa-users fa-2x text-dark mb-2"></i>
                            <h5 class="card-title">Nómina</h5>
                            <p class="card-text">Consulta la nómina de los estudiantes.</p>
                        </div>
                    </a>
                </div>
                <!-- Reporte de Notas -->
                <div class="col-md-3 mb-3">
                    <a href="<?php echo e(route('reporte.curso.notas', $curso->id)); ?>" class="card h-100 text-decoration-none text-dark" target="_blank">
                        <div class="card-body text-center">
                            <i class="fas fa-file-pdf fa-2x text-danger mb-2"></i>
                            <h5 class="card-title">Reporte de Notas</h5>
                            <p class="card-text">Visualiza el informe PDF de notas por logros.</p>
                        </div>
                    </a>
                </div>

                <!-- Reporte de Notas -->
                <div class="col-md-3 mb-3">
                    <a href="<?php echo e(route('docente.acta.final', $curso->id)); ?>" class="card h-100 text-decoration-none text-dark" target="_blank">
                        <div class="card-body text-center">
                            <i class="fas fa-file-pdf fa-2x text-danger mb-2"></i>
                            <h5 class="card-title">Acta Final </h5>
                            <p class="card-text">Visualiza el informe PDF de notas por logros.</p>
                        </div>
                    </a>
                </div>


            </div>


            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>










<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>









<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/docentes/cursos/informacion.blade.php ENDPATH**/ ?>