<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Material de Clases: <?php echo e($curso->nombre); ?> <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                

                <div class="mb-3 text-end">
                    <a href="<?php echo e(route('docente.cursos.informacion', $curso->id)); ?>" class="btn btn-danger btn-sm me-2">
                        <i class="fas fa-arrow-left"></i> Volver a Información del Curso
                    </a>
                    
                    <button type="button" class="btn btn-primary btn-sm px-3" 
                        data-bs-toggle="modal" 
                        data-bs-target="#modalNuevoArchivo">
                        <i class="fas fa-plus"></i> Agregar Material de Clases
                    </button>
                </div>
                <div class="table-responsive">
                    <table id="tablaLogros" class="table table-bordered table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Tipo</th>
                                <th>Nombre</th>
                                <th>Sesión</th> <!-- nueva columna -->
                                <th>Archivo/Video</th>
                                <th>Fecha</th>
                                <th class="text-center">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $archivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $archivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($archivo->tipo === 'video' ? 'warning' : 'secondary'); ?>">
                                        <?php echo e(ucfirst($archivo->tipo)); ?>

                                    </span>
                                </td>
                                <td><?php echo e($archivo->nombre); ?></td>
                                <td>
                                    <?php if($archivo->sesion): ?>
                                        <span class="badge bg-primary"><?php echo e($archivo->sesion->nombre); ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">Sin sesión</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($archivo->tipo === 'video'): ?>
                                        <a href="<?php echo e($archivo->ruta); ?>" target="_blank" class="btn btn-outline-info btn-sm">
                                            <i class="fas fa-play-circle"></i> Ver video
                                        </a>
                                    <?php else: ?>
                                        <a href="<?php echo e(asset('storage/' . $archivo->ruta)); ?>" target="_blank" class="btn btn-outline-success btn-sm">
                                            <i class="fas fa-download"></i> Descargar
                                        </a>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(\Carbon\Carbon::parse($archivo->fecha_subida)->format('d/m/Y H:i')); ?></td>
                                <td class="text-center">
                                    <form method="POST" action="<?php echo e(route('docente.archivos.destroy', $archivo->id)); ?>" class="d-inline-block eliminar-form">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="button" class="btn btn-danger btn-sm btnEliminarArchivo" data-id="<?php echo e($archivo->id); ?>">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>



                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->

<div class="modal fade" id="modalNuevoArchivo" tabindex="-1" aria-labelledby="modalNuevoArchivoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="formNuevoArchivo" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Subir nuevo archivo o video</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="curso_id" value="<?php echo e($curso->id); ?>">

                    <div class="mb-3">
                        <label for="sesion_id" class="form-label">Sesión (opcional)</label>
                        <select name="sesion_id" id="sesion_id" class="form-select">
                            <option value="">-- Selecciona una sesión --</option>
                            <?php $__currentLoopData = $sesiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sesion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($sesion->id_sesion); ?>"><?php echo e($sesion->nombre); ?> (<?php echo e(\Carbon\Carbon::parse($sesion->fecha)->format('d/m/Y')); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>


                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre</label>
                        <input type="text" name="nombre" id="nombre" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label for="tipo" class="form-label">Tipo</label>
                        <select name="tipo" id="tipo" class="form-select" required>
                            <option value="archivo">Archivo</option>
                            <option value="video">Video (URL)</option>
                        </select>
                    </div>

                    <div class="mb-3" id="campoArchivo">
                        <label for="archivo" class="form-label">Seleccionar archivo</label>
                        <input type="file" name="archivo" id="archivo" class="form-control" accept=".pdf,.docx,.jpg,.jpeg,.png">
                    </div>

                    <div class="mb-3 d-none" id="campoVideo">
                        <label for="url_video" class="form-label">Enlace del video</label>
                        <input type="url" name="url_video" id="url_video" class="form-control" placeholder="https://...">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Subir</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </div>
        </form>
    </div>
</div>




<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- DataTables  -->
<script>
    $(document).ready(function () {
        $("#tablaLogros").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaLogros_wrapper .col-md-6:eq(0)');
    });
</script>
<!-- agregar  -->
<script>
    document.getElementById('tipo').addEventListener('change', function () {
        const tipo = this.value;
        const campoArchivo = document.getElementById('campoArchivo');
        const campoVideo = document.getElementById('campoVideo');

        if (tipo === 'archivo') {
            campoArchivo.classList.remove('d-none');
            campoVideo.classList.add('d-none');
        } else {
            campoArchivo.classList.add('d-none');
            campoVideo.classList.remove('d-none');
        }
    });

    // Manejar el envío
    document.getElementById('formNuevoArchivo').addEventListener('submit', function (e) {
        e.preventDefault();
        const cursoId = "<?php echo e($curso->id); ?>";
        const form = this;
        const tipo = document.getElementById('tipo').value;

        const formData = new FormData();

        formData.append('nombre', form.nombre.value);
        formData.append('tipo', tipo);
        formData.append('_token', form._token.value); // CSRF token

        // ✅ Agregar el ID de la sesión (puede ser null)
        const sesionId = form.sesion_id.value;
        if (sesionId) {
            formData.append('sesion_id', sesionId);
        }

        if (tipo === 'archivo') {
            const archivo = form.archivo.files[0];
            if (!archivo) {
                Swal.fire('Error', 'Debes seleccionar un archivo.', 'error');
                return;
            }
            formData.append('archivo', archivo);
        } else {
            const url = form.url_video.value;
            if (!url) {
                Swal.fire('Error', 'Debes ingresar un enlace de video.', 'error');
                return;
            }
            formData.append('ruta_video', url);
        }

        axios.post(`/docentes/cursos/${cursoId}/archivos`, formData)
            .then(res => {
                Swal.fire('¡Éxito!', res.data.message, 'success').then(() => location.reload());
            })
            .catch(err => {
                console.log(err.response);
                Swal.fire('Error', err.response?.data?.message || 'Hubo un error al subir el archivo.', 'error');
            });
    });
</script>




<!-- eliminar -->
<script>
    document.querySelectorAll('.btnEliminarArchivo').forEach(btn => {
        btn.addEventListener('click', function () {
            const archivoId = this.getAttribute('data-id');

            Swal.fire({
                title: '¿Estás seguro?',
                text: "Este archivo se eliminará permanentemente.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    axios.delete(`/docentes/archivos/${archivoId}`, {
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        }
                    })
                    .then(response => {
                        Swal.fire('¡Eliminado!', response.data.message, 'success').then(() => location.reload());
                    })
                    .catch(error => {
                        Swal.fire('Error', 'No se pudo eliminar el archivo.', 'error');
                    });
                }
            });
        });
    });
</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/docentes/archivos/index.blade.php ENDPATH**/ ?>