<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CursoDocente extends Model
{
    protected $table = 'cursos_docentes';

    protected $fillable = [
        'curso_id',
        'docente_id',
    ];

    public function curso()
    {
        return $this->belongsTo(Curso::class, 'curso_id');
    }

    public function docente()
    {
        return $this->belongsTo(Docente::class, 'docente_id');
    }
}
