<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Tramite extends Model
{
    protected $table = 'tramites';

    protected $primaryKey = 'id';

    public $timestamps = true;

    protected $fillable = [
        'nombre',
        'descripcion',
        'estado',
        'costo',
        'tiempo',
        'fecha_creacion',
        'fecha_actualizacion',
    ];

    /**
     * Relación muchos a muchos con RequisitoTramite
     */
    public function requisitos()
    {
        return $this->belongsToMany(
            RequisitoTramite::class,   // Modelo relacionado
            'tramite_requisitos',      // Tabla pivote
            'tramite_id',              // FK en pivote hacia este modelo
            'requisito_id'             // FK en pivote hacia el modelo relacionado
        )->withTimestamps();
    }
}
