<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TransaccionCaja extends Model
{
    protected $table = 'transacciones_caja';
    protected $primaryKey = 'id_transaccion';

    protected $fillable = [
        'caja_id', 'tipo', 'monto', 'fecha', 'concepto_id', 'observacion',
        'estado', 'dni', 'nombres', 'apellidos'
    ];

    public function caja()
    {
        return $this->belongsTo(Caja::class, 'caja_id');
    }

    public function concepto()
    {
        return $this->belongsTo(Concepto::class, 'concepto_id');
    }

    public function anulacion()
    {
        return $this->hasOne(AnulacionTransaccion::class, 'id_transaccion');
    }
}
