@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Tareas del Curso {{ $curso->nombre }} @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <div class="mb-3 text-end">
                    <a href="{{ route('docente.cursos.informacion', $curso->id) }}" class="btn btn-danger btn-sm me-2">
                        <i class="fas fa-arrow-left"></i> Volver a Información del Curso
                    </a>
                    
                    <button type="button" class="btn btn-primary btn-sm px-3" 
                        data-bs-toggle="modal" 
                        data-bs-target="#modalNuevaTarea">
                        <i class="fas fa-plus"></i> Agregar Nueva Tarea
                    </button>
                </div>

                <div class="row">
                    @forelse ($tareas as $tarea)
                        <div class="col-md-4 mb-3">
                            <div class="card shadow-sm h-100">
                                <div class="card-body">
                                    <h5 class="card-title text-primary fw-bold">
                                        <i class="fas fa-tasks"></i> {{ $tarea->nombre }}
                                    </h5>

                                    <p class="text-muted mb-2" style="font-size: 14px;">
                                        {{ $tarea->descripcion ?? 'Sin descripción' }}
                                    </p>

                                    <p class="mb-1">
                                        <strong>Fecha:</strong> 
                                        {{ $tarea->fecha ? $tarea->fecha->format('d/m/Y') : '-' }}
                                    </p>

                                    <p class="mb-1">
                                        <strong>Hora:</strong>
                                        {{ $tarea->hora_inicio }} - {{ $tarea->hora_fin }}
                                    </p>

                                    <p class="mb-1">
                                        <strong>Sesión:</strong> {{ $tarea->sesion->nombre ?? '-' }}
                                    </p>

                                    <p class="mb-3">
                                        <strong>Subcomponente:</strong> {{ $tarea->subcomponente->nombre ?? '-' }}
                                    </p>

                                    {{-- ARCHIVO ADJUNTO --}}
                                        @if($tarea->archivo)
                                            <p class="mb-3">
                                                <strong>Archivo:</strong><br>
                                                <a href="{{ asset('tareas/' . $tarea->archivo) }}" 
                                                target="_blank" 
                                                class="btn btn-outline-primary btn-sm mt-1">
                                                    <i class="fas fa-file-alt"></i> Ver archivo
                                                </a>
                                            </p>
                                        @endif

                                    <div class="text-end">
                                        
                                        <!-- EDITAR -->
                                        <button class="btn btn-warning btn-sm" 
                                                data-bs-toggle="modal"
                                                data-bs-target="#modalEditarTarea{{ $tarea->id }}">
                                            <i class="fas fa-edit"></i>
                                        </button>

                                        <!-- ELIMINAR -->
                                        <button class="btn btn-danger btn-sm btnEliminarTarea"
                                                data-id="{{ $tarea->id }}">
                                            <i class="fas fa-trash"></i>
                                        </button>

                                    </div>

                                </div>
                            </div>
                        </div>
                    @empty
                        <p class="text-center text-muted">No hay tareas registradas en este curso.</p>
                    @endforelse
                </div>

            </div>
        </div>
    </div>
</div>


<!-- Modal de agregar -->

<!-- Modal Nueva Sesión -->
<!-- Modal Nueva Sesión -->
<div class="modal fade" id="modalNuevaTarea" tabindex="-1" aria-labelledby="modalNuevaTareaLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg"> {{-- modal-lg para más espacio --}}
        <div class="modal-content">
            
            <div class="modal-header">
                <h5 class="modal-title" id="modalNuevaTareaLabel">Registrar Nueva Tarea</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>

            <div class="modal-body">
                <form id="formNuevaTarea" enctype="multipart/form-data">
                    @csrf

                    {{-- NOMBRE --}}
                    <div class="mb-3">
                        <label for="nombre_tarea" class="form-label">Nombre de la Tarea</label>
                        <input type="text" id="nombre_tarea" name="nombre" class="form-control" required>
                    </div>

                    {{-- DESCRIPCIÓN --}}
                    <div class="mb-3">
                        <label for="descripcion_tarea" class="form-label">Descripción</label>
                        <textarea id="descripcion_tarea" name="descripcion" class="form-control" rows="3"></textarea>
                    </div>

                    {{-- FECHAS --}}
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="fecha" class="form-label">Fecha de Inicio</label>
                            <input type="date" id="fecha" name="fecha" class="form-control">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="fecha_fin" class="form-label">Fecha de Fin</label>
                            <input type="date" id="fecha_fin" name="fecha_fin" class="form-control">
                        </div>
                    </div>

                    {{-- HORARIOS --}}
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="hora_inicio" class="form-label">Hora Inicio</label>
                            <input type="time" id="hora_inicio" name="hora_inicio" class="form-control">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="hora_fin" class="form-label">Hora Fin</label>
                            <input type="time" id="hora_fin" name="hora_fin" class="form-control">
                        </div>
                    </div>

                    {{-- SUBCOMPONENTE --}}
                    <div class="mb-3">
                        <label for="subcomponente_id" class="form-label">Subcomponente</label>
                        <select id="subcomponente_id" name="subcomponente_id" class="form-select">
                            <option value="">-- Seleccionar --</option>
                            @foreach($subcomponentes as $sub)
                                <option value="{{ $sub->id }}">{{ $sub->nombre }}</option>
                            @endforeach
                        </select>
                    </div>

                    {{-- SESIÓN --}}
                    <div class="mb-3">
                        <label for="sesion_id" class="form-label">Sesión</label>
                        <select id="sesion_id" name="sesion_id" class="form-select">
                            <option value="">-- Seleccionar --</option>
                            @foreach($sesiones as $sesion)
                                <option value="{{ $sesion->id_sesion }}">{{ $sesion->nombre }}</option>
                            @endforeach
                        </select>
                    </div>

                    {{-- ARCHIVO --}}
                    <div class="mb-3">
                        <label for="archivo" class="form-label">Archivo Adjunto (opcional)</label>
                        <input type="file" id="archivo" name="archivo" class="form-control">
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        <button type="submit" class="btn btn-de-primary">Guardar Tarea</button>
                    </div>

                </form>
            </div>

        </div>
    </div>
</div>


<!-- MODAL EDITAR TAREA -->
<!-- MODAL EDITAR TAREA -->
<div class="modal fade" id="modalEditarTarea{{ $tarea->id }}" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <div class="modal-header bg-warning">
                <h5 class="modal-title">Editar Tarea</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">

                <form class="formEditarTarea"
                      data-id="{{ $tarea->id }}"
                      enctype="multipart/form-data">
                    @csrf

                    {{-- NOMBRE --}}
                    <div class="mb-3">
                        <label class="form-label">Nombre de la Tarea</label>
                        <input type="text" name="nombre" class="form-control"
                               value="{{ $tarea->nombre }}" required>
                    </div>

                    {{-- DESCRIPCIÓN --}}
                    <div class="mb-3">
                        <label class="form-label">Descripción</label>
                        <textarea name="descripcion" class="form-control" rows="3">{{ $tarea->descripcion }}</textarea>
                    </div>

                    {{-- FECHAS --}}
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Fecha Inicio</label>
                            <input type="date" name="fecha" class="form-control"
                                   value="{{ $tarea->fecha ? $tarea->fecha->format('Y-m-d') : '' }}">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Fecha Fin</label>
                            <input type="date" name="fecha_fin" class="form-control"
                                   value="{{ $tarea->fecha_fin ? $tarea->fecha_fin->format('Y-m-d') : '' }}">
                        </div>
                    </div>

                    {{-- HORAS --}}
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Hora Inicio</label>
                            <input type="time" name="hora_inicio" class="form-control"
                                   value="{{ $tarea->hora_inicio ? \Carbon\Carbon::parse($tarea->hora_inicio)->format('H:i') : '' }}">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Hora Fin</label>
                            <input type="time" name="hora_fin" class="form-control"
                                   value="{{ $tarea->hora_fin ? \Carbon\Carbon::parse($tarea->hora_fin)->format('H:i') : '' }}">
                        </div>
                    </div>

                    {{-- SUBCOMPONENTE --}}
                    <div class="mb-3">
                        <label class="form-label">Subcomponente</label>
                        <select name="subcomponente_id" class="form-select">

                            {{-- Caso: tarea sin subcomponente asignado --}}
                            @if(!$tarea->subcomponente_id)
                                <option value="" selected>-- Seleccionar --</option>
                            @endif

                            {{-- Caso: subcomponente eliminado del sistema --}}
                            @if($tarea->subcomponente_id && !$subcomponentes->contains('id', $tarea->subcomponente_id))
                                <option value="{{ $tarea->subcomponente_id }}" selected>(Subcomponente no disponible)</option>
                            @endif

                            {{-- Listado normal --}}
                            @foreach($subcomponentes as $sub)
                                <option value="{{ $sub->id }}"
                                    {{ $tarea->subcomponente_id == $sub->id ? 'selected' : '' }}>
                                    {{ $sub->nombre }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- SESIÓN --}}
                    <div class="mb-3">
                        <label class="form-label">Sesión</label>
                        <select name="sesion_id" class="form-select">

                            {{-- Caso: sin sesión asignada --}}
                            @if(!$tarea->sesion_id)
                                <option value="" selected>-- Seleccionar --</option>
                            @endif

                            {{-- Caso: sesión eliminada --}}
                            @if($tarea->sesion_id && !$sesiones->contains('id_sesion', $tarea->sesion_id))
                                <option value="{{ $tarea->sesion_id }}" selected>(Sesión no disponible)</option>
                            @endif

                            {{-- Listado normal --}}
                            @foreach($sesiones as $sesion)
                                <option value="{{ $sesion->id_sesion }}"
                                    {{ $tarea->sesion_id == $sesion->id_sesion ? 'selected' : '' }}>
                                    {{ $sesion->nombre }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- ARCHIVO ACTUAL --}}
                    @if($tarea->archivo)
                        <div class="mb-3">
                            <strong>Archivo actual:</strong><br>
                            <a href="{{ asset('tareas/' . $tarea->archivo) }}" 
                               target="_blank"
                               class="btn btn-outline-primary btn-sm mt-1">
                                <i class="fas fa-file-alt"></i> Ver archivo
                            </a>
                        </div>
                    @endif

                    {{-- SUBIR ARCHIVO NUEVO --}}
                    <div class="mb-3">
                        <label class="form-label">Reemplazar Archivo (opcional)</label>
                        <input type="file" name="archivo" class="form-control">
                    </div>

                    {{-- BOTONES --}}
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        <button type="submit" class="btn btn-warning">Guardar Cambios</button>
                    </div>

                </form>

            </div>

        </div>
    </div>
</div>









<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>



<script>
$(document).ready(function() {

    $('#formNuevaTarea').on('submit', function(e) {
        e.preventDefault();

        // Crear FormData (soporta archivos)
        let formData = new FormData(this);

        Swal.fire({
            title: 'Guardando tarea...',
            text: 'Por favor espere.',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: "{{ route('docente.tareas.store', $curso->id) }}",
            type: "POST",
            data: formData,
            processData: false, // Importante para FormData
            contentType: false, // Importante para FormData
            success: function(response) {

                Swal.close();

                Swal.fire({
                    icon: 'success',
                    title: '¡Tarea registrada!',
                    text: 'La tarea se guardó correctamente.',
                    timer: 1500,
                    showConfirmButton: false
                });

                // Cerrar modal
                $('#modalNuevaTarea').modal('hide');

                // Limpiar formulario
                $('#formNuevaTarea')[0].reset();

                // Recargar listado (si lo necesitas)
                // location.reload();

            },
            error: function(xhr) {
                Swal.close();

                let message = "Ocurrió un error al guardar la tarea.";

                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: message
                });
            }
        });

    });

});
</script>

<script>
$(document).ready(function(){

    $('.formEditarTarea').on('submit', function(e){
        e.preventDefault();

        let id = $(this).data('id');
        let form = this;
        let formData = new FormData(form);

        Swal.fire({
            title: 'Actualizando...',
            text: 'Por favor espere.',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: "/docentes/tareas/" + id, // ruta PUT
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                'X-HTTP-Method-Override': 'PUT' // Laravel necesita PUT
            },
            success: function(resp){

                Swal.close();

                Swal.fire({
                    icon: 'success',
                    title: 'Tarea actualizada',
                    text: resp.message,
                    timer: 1500,
                    showConfirmButton: false
                });

                // Cerrar modal
                $('#modalEditarTarea' + id).modal('hide');

                // Opcional: recargar página para ver cambios
                location.reload();
            },
            error: function(xhr){
                Swal.close();

                let msg = "Error al actualizar la tarea.";
                if(xhr.responseJSON && xhr.responseJSON.message){
                    msg = xhr.responseJSON.message;
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: msg
                });
            }
        });

    });

});
</script>
<script>
$(document).on('click', '.btnEliminarTarea', function () {

    let tareaId = $(this).data('id');
    let button = $(this);

    Swal.fire({
        title: "¿Eliminar tarea?",
        text: "Esta acción no se puede deshacer.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Sí, eliminar",
        cancelButtonText: "Cancelar",
        confirmButtonColor: "#d33",
        cancelButtonColor: "#6c757d"
    }).then((result) => {
        if (result.isConfirmed) {

            Swal.fire({
                title: 'Eliminando...',
                text: 'Por favor espere.',
                allowOutsideClick: false,
                didOpen: () => Swal.showLoading()
            });

            $.ajax({
                url: "/docentes/tareas/" + tareaId,
                type: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function (response) {
                    Swal.close();

                    Swal.fire({
                        icon: "success",
                        title: "Eliminado",
                        text: response.message,
                        timer: 1500,
                        showConfirmButton: false
                    });

                    // Animación y eliminación de la tarjeta
                    button.closest(".col-md-4").fadeOut(300, function () {
                        $(this).remove();
                    });
                },
                error: function () {
                    Swal.fire({
                        icon: "error",
                        title: "Error",
                        text: "No se pudo eliminar la tarea."
                    });
                }
            });

        }
    });

});
</script>

@endsection
