@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Estudiantes @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <h3 class="mb-4 text-primary">
    <i class="fas fa-history"></i> Historial Académico
</h3>

@foreach($matriculas as $mat)
    <div class="card mb-4 shadow-sm">
        <div class="card-header bg-primary text-white">
            <strong>Semestre:</strong> {{ $mat->semestre->nombre ?? '---' }}
            &nbsp; | &nbsp;
            <strong>Período:</strong> {{ $mat->periodo->nombre ?? '---' }}
            &nbsp; | &nbsp;
            <strong>Fecha Matrícula:</strong> {{ $mat->fecha_matricula }}
        </div>

        <div class="card-body p-0">
            <table class="table table-bordered mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Curso</th>
                        <th>Módulo</th>
                        <th>Estado</th>
                        <th>Nota Final</th>
                    </tr>
                </thead>

                <tbody>
                @foreach($mat->matriculaCursos as $mc)
                    <tr>
                        <td><strong>{{ $mc->curso->nombre }}</strong></td>

                        <td>{{ $mc->curso->modulo->nombre ?? '-' }}</td>

                        <td>
                            <span class="badge bg-info text-dark">
                                {{ $mc->estado }}
                            </span>
                        </td>

                        <td>
                            @php
                                $nota = $mc->curso->notaFinal
                                    ->where('estudiante_id', Auth::user()->estudiante->id_postulante)
                                    ->first();
                            @endphp

                            @if($nota)
                                <span class="badge bg-success">{{ $nota->promedio }}</span>
                            @else
                                <span class="badge bg-secondary">Sin Nota</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endforeach

               
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal para crear nuevo requisito -->









<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>










@endsection
