<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Silabo del Curso <?php echo e($curso->nombre); ?> <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <div class="mb-3 text-end">
                    <a href="<?php echo e(route('docente.cursos.informacion', $curso->id)); ?>" class="btn btn-danger btn-sm me-2">
                        <i class="fas fa-arrow-left"></i> Volver a Información del Curso
                    </a>
                    
                    <button type="button" class="btn btn-primary btn-sm px-3" 
                        data-bs-toggle="modal" 
                        data-bs-target="#modalNuevoSilabo">
                        <i class="fas fa-plus"></i> Agregar Nuevo Silabo
                    </button>
                </div>


                <div class="row">
                    <?php if($silabo): ?>
                        <div class="card">
                            <div class="card-body text-center">
                                <h5 class="card-title">Sílabo Disponible</h5>
                                <p class="card-text">Subido el: <?php echo e(\Carbon\Carbon::parse($silabo->fecha_subida)->format('d/m/Y')); ?></p>
                                <a href="<?php echo e(asset('storage/' . $silabo->archivo)); ?>" target="_blank" class="btn btn-primary">
                                    Ver o Descargar Sílabo
                                </a>
                                <button type="button" 
                                    class="btn btn-danger" 
                                    onclick="eliminarSilabo(<?php echo e($silabo->id_silabo); ?>)">
                                    <i class="fas fa-trash-alt"></i> Eliminar Sílabo
                                </button>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning text-center">
                            No se ha subido un sílabo para este curso aún.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal de agregar -->

<!-- Modal: Agregar Nuevo Silabo -->
<div class="modal fade" id="modalNuevoSilabo" tabindex="-1" aria-labelledby="modalNuevoSilaboLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formNuevoSilabo" enctype="multipart/form-data">
      <?php echo csrf_field(); ?>
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalNuevoSilaboLabel">Agregar Nuevo Silabo</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <div class="mb-3">
            <label for="archivo" class="form-label">Archivo del Sílabo (PDF)</label>
            <input type="file" class="form-control" id="archivo" name="archivo" accept="application/pdf" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success">
            <i class="fas fa-save"></i> Guardar
          </button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
            Cancelar
          </button>
        </div>
      </div>
    </form>
  </div>
</div>

<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

<!-- Agregar -->
<script>
    $(document).ready(function() {
        $('#formNuevoSilabo').submit(function(e) {
            e.preventDefault();

            var formData = new FormData(this);

            $.ajax({
                url: '<?php echo e(route('docente.silabos.store', $curso->id)); ?>', // esta ruta la creamos ahorita
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    $('#modalNuevoSilabo').modal('hide');

                    Swal.fire({
                        icon: 'success',
                        title: '¡Sílabo subido!',
                        text: response.message,
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        location.reload();
                    });
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Hubo un problema al subir el silabo.'
                    });
                }
            });
        });
    });
</script>


<!-- eliminar -->
<!-- Script de AJAX para eliminar -->
<script>
    function eliminarSilabo(id_silabo) {
        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡Esta acción no se puede deshacer!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {

                fetch("<?php echo e(url('docentes/silabos')); ?>/" + id_silabo, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Accept': 'application/json'
                    },
                })
                .then(response => response.json())
                .then(data => {
                    Swal.fire(
                        'Eliminado',
                        data.message,
                        'success'
                    ).then(() => {
                        location.reload(); // Recarga la página para actualizar
                    });
                })
                .catch(error => {
                    console.error('Error:', error);
                    Swal.fire(
                        'Error',
                        'Hubo un problema al eliminar.',
                        'error'
                    );
                });

            }
        })
    }
</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/docentes/silabos/index.blade.php ENDPATH**/ ?>