<?php $__env->startSection('title', 'Detalle del Curso'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h3 class="mb-4 text-primary"><?php echo e($curso->nombre); ?></h3>

    <div class="accordion" id="accordionSesiones">
        <?php $__empty_1 = true; $__currentLoopData = $sesiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sesion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="accordion-item rounded-3 shadow-sm mb-3 border-0">
            <h2 class="accordion-header" id="heading<?php echo e($sesion->id_sesion); ?>">
                <button class="accordion-button collapsed rounded-3 d-flex justify-content-between align-items-center"
                    type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapse<?php echo e($sesion->id_sesion); ?>"
                    aria-expanded="false" aria-controls="collapse<?php echo e($sesion->id_sesion); ?>">
                    <div>
                        <strong><?php echo e($sesion->nombre); ?></strong> 
                        <small class="text-muted ms-2">(<?php echo e(\Carbon\Carbon::parse($sesion->fecha)->format('d/m/Y')); ?>)</small>
                    </div>
                    <span class="badge bg-<?php echo e($sesion->activo ? 'success' : 'secondary'); ?>">
                        <?php echo e($sesion->activo ? 'Activa' : 'Inactiva'); ?>

                    </span>
                </button>
            </h2>

            <div id="collapse<?php echo e($sesion->id_sesion); ?>" class="accordion-collapse collapse"
                aria-labelledby="heading<?php echo e($sesion->id_sesion); ?>" data-bs-parent="#accordionSesiones">
                <div class="accordion-body py-4">
                    <ul class="nav nav-tabs mb-3" id="tabs<?php echo e($sesion->id_sesion); ?>" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="archivos-tab-<?php echo e($sesion->id_sesion); ?>" data-bs-toggle="tab" data-bs-target="#archivos-<?php echo e($sesion->id_sesion); ?>" type="button" role="tab" aria-controls="archivos-<?php echo e($sesion->id_sesion); ?>" aria-selected="true">
                                Archivos
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="videos-tab-<?php echo e($sesion->id_sesion); ?>" data-bs-toggle="tab" data-bs-target="#videos-<?php echo e($sesion->id_sesion); ?>" type="button" role="tab" aria-controls="videos-<?php echo e($sesion->id_sesion); ?>" aria-selected="false">
                                Videos
                            </button>
                        </li>
                    </ul>

                    <div class="tab-content" id="tabsContent<?php echo e($sesion->id_sesion); ?>">
                        
                        <div class="tab-pane fade show active" id="archivos-<?php echo e($sesion->id_sesion); ?>" role="tabpanel" aria-labelledby="archivos-tab-<?php echo e($sesion->id_sesion); ?>">
                            <?php if($sesion->archivos->where('tipo', 'archivo')->isEmpty()): ?>
                                <p class="text-muted fst-italic">No hay archivos disponibles.</p>
                            <?php else: ?>
                                <ul class="list-group list-group-flush">
                                    <?php $__currentLoopData = $sesion->archivos->where('tipo', 'archivo'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $archivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-center border-0 px-0">
                                            <div class="d-flex align-items-center gap-3">
                                                <i class="bi bi-file-earmark-pdf-fill text-danger fs-4"></i>
                                                <span><?php echo e($archivo->nombre); ?></span>
                                            </div>
                                            <a href="<?php echo e(asset('storage/archivos_curso/' . $archivo->ruta)); ?>" target="_blank" 
                                            class="btn btn-sm btn-outline-primary"
                                            style="max-width:120px; padding:0.25rem 0.5rem; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; font-size:0.875rem;"
                                            rel="noopener noreferrer" 
                                            aria-label="Descargar <?php echo e($archivo->nombre); ?>">
                                                Descargar
                                            </a>

                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </div>

                        
                        <div class="tab-pane fade" id="videos-<?php echo e($sesion->id_sesion); ?>" role="tabpanel" aria-labelledby="videos-tab-<?php echo e($sesion->id_sesion); ?>">
                            <?php if($sesion->archivos->where('tipo', 'video')->isEmpty()): ?>
                                <p class="text-muted fst-italic">No hay videos disponibles.</p>
                            <?php else: ?>
                                <div class="row row-cols-1 row-cols-md-2 g-4">
                                    <?php $__currentLoopData = $sesion->archivos->where('tipo', 'video'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $youtubeId = null;
                                            if (str_contains($video->ruta, 'youtube.com') || str_contains($video->ruta, 'youtu.be')) {
                                                if (str_contains($video->ruta, 'youtu.be')) {
                                                    $parts = explode('/', $video->ruta);
                                                    $youtubeId = end($parts);
                                                } else {
                                                    parse_str(parse_url($video->ruta, PHP_URL_QUERY), $queryParams);
                                                    $youtubeId = $queryParams['v'] ?? null;
                                                }
                                            }
                                        ?>
                                        <div class="col">
                                            <div class="card shadow-sm rounded-3 h-100">
                                                <?php if($youtubeId): ?>
                                                    <div class="ratio ratio-16x9 rounded-top">
                                                        <iframe 
                                                            src="https://www.youtube.com/embed/<?php echo e($youtubeId); ?>" 
                                                            title="<?php echo e($video->nombre); ?>" 
                                                            allowfullscreen 
                                                            loading="lazy"
                                                            frameborder="0"
                                                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                                            class="rounded-top">
                                                        </iframe>
                                                    </div>
                                                <?php else: ?>
                                                    <video controls preload="metadata" class="w-100 rounded-top">
                                                        <source src="<?php echo e(asset('storage/archivos_curso/' . $video->ruta)); ?>" type="video/mp4">
                                                        Tu navegador no soporta video HTML5.
                                                    </video>
                                                <?php endif; ?>
                                                <div class="card-body">
                                                    <h6 class="card-title mb-0 text-truncate" title="<?php echo e($video->nombre); ?>"><?php echo e($video->nombre); ?></h6>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="alert alert-info">No hay sesiones registradas aún.</div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/estudiantes/cursos/ver.blade.php ENDPATH**/ ?>