<?php

namespace App\Http\Controllers\Estudiante;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Curso;
use App\Models\Postulante;
use App\Models\Sesion;
use Illuminate\Http\Request;

class CursosEstudianteController extends Controller
{
    public function verCurso($cursoId)
    {
        $usuario = Auth::user();
        $postulante = Postulante::where('usuario_id', $usuario->id)->first();

        // Validar que el curso realmente esté matriculado por este postulante
        $matriculaCurso = $postulante->matriculas()
            ->whereHas('matriculaCursos', fn($q) => $q->where('curso_id', $cursoId))
            ->with(['matriculaCursos' => fn($q) => $q->where('curso_id', $cursoId)])
            ->first();

        if (!$matriculaCurso) {
            abort(403, 'No estás matriculado en este curso.');
        }

        $curso = Curso::findOrFail($cursoId);

        // Obtener sesiones y archivos relacionados
        $sesiones = Sesion::with(['archivos']) // archivos es la relación con archivos_curso
            ->where('curso_id', $cursoId)
            ->orderBy('fecha')
            ->get();

        return view('estudiantes.cursos.ver', compact('curso', 'sesiones'));
    }
}
