<?php

namespace App\Http\Controllers;

use App\Models\Pabellon;
use Illuminate\Http\Request;

class PabellonController extends Controller
{
    /**
     * Mostrar listado de pabellones.
     */
    public function index()
    {
        $pabellones = Pabellon::orderBy('nombre', 'asc')->get();
        return view('pabellones.index', compact('pabellones'));
    }

    /**
     * Guardar un nuevo pabellón.
     */
   public function store(Request $request)
{
    $request->validate([
        'nombre' => 'required|string|max:100',
        'descripcion' => 'nullable|string|max:500',
    ]);

    try {

        $pabellon = Pabellon::create([
            'nombre' => $request->nombre,
            'descripcion' => $request->descripcion,
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Pabellón registrado correctamente.',
            'data' => $pabellon
        ]);

    } catch (\Exception $e) {

        return response()->json([
            'success' => false,
            'message' => 'Ocurrió un error al registrar el pabellón.',
            'error' => $e->getMessage()
        ], 500);

    }
}


    /**
     * Actualizar un pabellón existente.
     */
    public function update(Request $request, $id)
{
    $pabellon = Pabellon::findOrFail($id);

    $request->validate([
        'nombre' => 'required|string|max:100',
        'descripcion' => 'nullable|string|max:500',
    ]);

    $pabellon->update([
        'nombre'      => $request->nombre,
        'descripcion' => $request->descripcion,
    ]);

    return response()->json([
        'success' => true,
        'message' => 'Pabellón actualizado correctamente.'
    ]);
}


    /**
     * Eliminar un pabellón (si no tiene aulas asociadas).
     */
    public function destroy($id)
{
    $pabellon = Pabellon::findOrFail($id);
    $pabellon->delete();

    return response()->json([
        'success' => true,
        'message' => 'Pabellón eliminado correctamente.'
    ]);
}

}
