<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NotaLogro extends Model
{
    protected $table = 'notas_logros';

    protected $fillable = [
        'estudiante_id',
        'curso_id',
        'logro_curso_id',
        'nota',
    ];

    public function estudiante()
    {
        return $this->belongsTo(Postulante::class, 'estudiante_id', 'id_postulante');
    }

    public function curso()
    {
        return $this->belongsTo(Curso::class);
    }

    public function logro()
    {
        return $this->belongsTo(LogroCurso::class, 'logro_curso_id');
    }
}
