<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Periodo extends Model
{
    use HasFactory;

    // Nombre de la tabla (si es diferente al nombre en plural del modelo)
    protected $table = 'periodos';
    // Especificar la clave primaria si no es 'id'
    protected $primaryKey = 'id';
    // Definir los campos que se pueden asignar masivamente
    protected $fillable = [
        'nombre', 
        'descripcion', 
        'fecha_inicio', 
        'fecha_fin', 
        'activo'
    ];

    // Definir los campos que son manejados automáticamente
    protected $dates = [
        'fecha_inicio',
        'fecha_fin',
        'fecha_creacion',
        'fecha_actualizacion',
    ];

    // Si deseas que el campo 'activo' sea un valor booleano
    protected $casts = [
        'activo' => 'boolean',
    ];

    public function planesEstudio()
    {
        return $this->belongsToMany(PlanEstudio::class, 'planes_estudio_periodos', 'periodo_id', 'plan_estudio_id');
    }
}
