@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Horario @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">

                <form action="{{ route('admisiones.store') }}" method="POST" id="form-admision">
                    @csrf

                    {{-- Card: Información del Proceso --}}
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-primary text-white d-flex align-items-center">
                            <i class="mdi mdi-information-outline me-2 fs-4"></i>
                            <h5 class="mb-0 text-white">Información del Proceso</h5>
                        </div>
                        <div class="card-body row g-3">
                            <div class="col-md-6">
                                <label for="nombre" class="form-label">Nombre del Proceso <span class="text-danger">*</span></label>
                                <input type="text" name="nombre" id="nombre" class="form-control" required>
                            </div>

                            <div class="col-md-6">
                                <label for="direccion" class="form-label">Dirección</label>
                                <input type="text" name="direccion" id="direccion" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label for="id_periodo" class="form-label">Periodo <span class="text-danger">*</span></label>
                                <select name="id_periodo" id="id_periodo" class="form-select" required>
                                    <option value="">Seleccione</option>
                                    @foreach ($periodos as $periodo)
                                        <option value="{{ $periodo->id }}">{{ $periodo->nombre }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label for="id_tipo_admision" class="form-label">Modalidad de Admisión <span class="text-danger">*</span></label>
                                <select name="id_tipo_admision" id="id_tipo_admision" class="form-select" required>
                                    <option value="">Seleccione</option>
                                    @foreach ($tiposAdmision as $tipo)
                                        <option value="{{ $tipo->id_tipo_admision }}">{{ $tipo->nombre }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    {{-- Card: Fechas del Proceso --}}
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-success text-white d-flex align-items-center">
                            <i class="mdi mdi-calendar-clock-outline me-2 fs-4"></i>
                            <h5 class="mb-0 text-white">Fechas del Proceso</h5>
                        </div>
                        <div class="card-body row g-3">
                            @php
                                $fechas = [
                                    'inicio_proceso' => 'Inicio del Proceso',
                                    'fin_proceso' => 'Fin del Proceso',
                                    'inicio_inscripciones' => 'Inicio de Inscripciones',
                                    'fin_inscripciones' => 'Fin de Inscripciones',
                                    'inicio_extemporaneo' => 'Inicio Extemporáneo',
                                    'fin_extemporaneo' => 'Fin Extemporáneo',
                                    'fecha_examen' => 'Fecha de Examen',
                                ];
                            @endphp

                            @foreach ($fechas as $name => $label)
                                <div class="col-md-4">
                                    <label for="{{ $name }}" class="form-label">{{ $label }}</label>
                                    <input type="date" name="{{ $name }}" id="{{ $name }}" class="form-control">
                                </div>
                            @endforeach
                        </div>
                    </div>

                    {{-- Card: Requisitos y Tipos de Pago --}}
                    <div class="card shadow-sm mb-4">
                        <div class="card-header bg-warning text-dark d-flex align-items-center">
                            <i class="mdi mdi-clipboard-list-outline me-2 fs-4"></i>
                            <h5 class="mb-0 text-white">Requisitos y Tipos de Pago</h5>
                        </div>
                        <div class="card-body row g-4">
                            <div class="col-md-6">
                                <label class="form-label">Requisitos</label>
                                <div class="border rounded p-3" style="max-height: 250px; overflow-y: auto;">
                                    @forelse ($requisitos as $requisito)
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="requisitos[]" value="{{ $requisito->id_requisito }}" id="req{{ $requisito->id_requisito }}">
                                            <label class="form-check-label" for="req{{ $requisito->id_requisito }}">{{ $requisito->nombre }}</label>
                                        </div>
                                    @empty
                                        <p class="text-muted">No hay requisitos disponibles.</p>
                                    @endforelse
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Tipos de Pago</label>
                                <div class="border rounded p-3" style="max-height: 250px; overflow-y: auto;">
                                    @forelse ($tiposPago as $pago)
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="tipos_pago[]" value="{{ $pago->id_tipo_pago }}" id="pago{{ $pago->id_tipo_pago }}">
                                            <label class="form-check-label" for="pago{{ $pago->id_tipo_pago }}">{{ $pago->nombre }}</label>
                                        </div>
                                    @empty
                                        <p class="text-muted">No hay tipos de pago disponibles.</p>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Botón de envío --}}
                    <div class="d-flex justify-content-end gap-2 mt-3">
                        <a href="{{ route('admisiones.index') }}" class="btn btn-danger">
                            <i class="mdi mdi-close-circle-outline me-1"></i>
                            Cancelar
                        </a>
                        <button type="submit" class="btn btn-lg btn-primary">
                            <i class="mdi mdi-content-save-outline me-1"></i>
                            Guardar Proceso de Admisión
                        </button>
                    </div>

                </form>


            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>









<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


<script>
    $(document).ready(function () {
        $('#form-admision').on('submit', function (e) {
            e.preventDefault();

            let form = $(this);
            let formData = form.serialize();

            $.ajax({
                type: 'POST',
                url: form.attr('action'),
                data: formData,
                beforeSend: function () {
                    // Puedes mostrar un loader si deseas
                },
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Registrado!',
                        text: 'El proceso de admisión fue registrado correctamente.',
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'Aceptar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = "{{ route('admisiones.index') }}";
                        }
                    });
                },
                error: function (xhr) {
                    let errores = xhr.responseJSON.errors;
                    let mensajes = '';
                    for (let campo in errores) {
                        errores[campo].forEach(function (mensaje) {
                            mensajes += `<div>• ${mensaje}</div>`;
                        });
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Error al registrar',
                        html: mensajes,
                        confirmButtonText: 'Cerrar'
                    });
                }
            });
        });
    });
</script>



@endsection
