<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Modalidad <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button type="button" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3"
                    data-bs-toggle="modal"
                    data-bs-target="#modalNuevoTipo">
                    <i class="fas fa-plus"></i> Agregar Modalidad
                </button>
                <div class="table-responsive">
                    
                    <table id="tablaTipoAdmision" class="table table-striped mb-0 table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Nombre</th>
                                <th>Monto</th>
                                <th>Monto Extemporáneo</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($tipo->id_tipo_admision); ?></td>
                                    <td><?php echo e($tipo->nombre); ?></td>
                                    <td>S/. <?php echo e(number_format($tipo->monto, 2)); ?></td>
                                    <td>S/. <?php echo e(number_format($tipo->monto_extemporaneo, 2)); ?></td>
                                    <td class="d-flex align-items-center gap-2">
                                        <div class="form-check form-switch m-0">
                                            <input class="form-check-input toggle-estado" type="checkbox"
                                                data-id="<?php echo e($tipo->id_tipo_admision); ?>"
                                                <?php echo e($tipo->activo ? 'checked' : ''); ?>>
                                        </div>
                                        <span class="badge <?php echo e($tipo->activo ? 'badge-soft-success' : 'badge-soft-warning'); ?>" id="estado-texto-<?php echo e($tipo->id_tipo_admision); ?>">
                                            <?php echo e($tipo->activo ? 'Activo' : 'Inactivo'); ?>

                                        </span>
                                    </td>


                                    <td>
                                        <!-- Botón editar -->
                                        <a href="#"
                                            class="text-warning me-2"
                                            data-bs-toggle="modal"
                                            data-bs-target="#modalEditarTipo"
                                            data-id="<?php echo e($tipo->id_tipo_admision); ?>"
                                            data-nombre="<?php echo e($tipo->nombre); ?>"
                                            data-monto="<?php echo e($tipo->monto); ?>"
                                            data-extemporaneo="<?php echo e($tipo->monto_extemporaneo); ?>"
                                            data-activo="<?php echo e($tipo->activo); ?>">
                                            <i class="las la-pen text-secondary font-18"></i>
                                        </a>


                                        <!-- Botón eliminar -->
                                        <form id="form-delete-<?php echo e($tipo->id_tipo_admision); ?>" action="<?php echo e(route('tipo_admision.destroy', $tipo->id_tipo_admision)); ?>" method="POST" class="d-inline delete-form">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                        <button type="button" class="btn btn-link p-0 m-0 align-baseline delete-button" data-id="<?php echo e($tipo->id_tipo_admision); ?>">
                                            <i class="las la-trash-alt text-secondary font-18"></i>
                                        </button>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal: Nuevo Tipo de Admisión -->
<div class="modal fade" id="modalNuevoTipo" tabindex="-1" aria-labelledby="modalNuevoTipoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form id="formNuevoTipo" action="<?php echo e(route('tipo_admision.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="modalNuevoTipoLabel">
                        <i class="fas fa-plus-circle me-2"></i> Nueva Modalidad de Admisión
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="nombre" name="nombre" maxlength="50" required>
                    </div>
                    <div class="mb-3">
                        <label for="monto" class="form-label">Monto Regular (S/)</label>
                        <input type="number" step="0.01" class="form-control" id="monto" name="monto" required>
                    </div>
                    <div class="mb-3">
                        <label for="monto_extemporaneo" class="form-label">Monto Extemporáneo (S/)</label>
                        <input type="number" step="0.01" class="form-control" id="monto_extemporaneo" name="monto_extemporaneo" required>
                    </div>
                    <div class="mb-3">
                        <label for="activo" class="form-label">Estado</label>
                        <select class="form-select" id="activo" name="activo">
                            <option value="1" selected>Activo</option>
                            <option value="0">Inactivo</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Registrar</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Modal Editar Tipo de Admisión -->
<div class="modal fade" id="modalEditarTipo" tabindex="-1" aria-labelledby="modalEditarTipoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="formEditarTipoAdmision">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="_method" value="PUT">
                <input type="hidden" id="edit_id" name="id_tipo_admision">

                <div class="modal-header">
                    <h5 class="modal-title" id="modalEditarTipoLabel">Editar Tipo de Admisión</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>

                <div class="modal-body">
                    <div class="mb-3">
                        <label>Nombre</label>
                        <input type="text" class="form-control" id="edit_nombre" name="nombre" required>
                    </div>

                    <div class="mb-3">
                        <label>Monto</label>
                        <input type="number" class="form-control" id="edit_monto" name="monto" required>
                    </div>

                    <div class="mb-3">
                        <label>Monto Extemporáneo</label>
                        <input type="number" class="form-control" id="edit_monto_extemporaneo" name="monto_extemporaneo" required>
                    </div>

                    
                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Guardar cambios</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>
<script src="<?php echo e(URL::asset('assets/plugins/tabulator/tabulator.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/tabulator/jspdf.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/tabulator/xlsx.full.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/tabulator/jspdf.plugin.autotable.js')); ?>"></script>
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- DataTables CSS -->
<script>
    $(document).ready(function () {
        $("#tablaTipoAdmision").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaTipoAdmision_wrapper .col-md-6:eq(0)');
    });
</script>
<!-- Agregar -->
<script>
    $(document).ready(function () {
        $('#formNuevoTipo').on('submit', function (e) {
            e.preventDefault();

            const form = $(this);
            const action = form.attr('action');
            const data = form.serialize();

            $.ajax({
                url: action,
                type: 'POST',
                data: data,
                success: function (response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Registrado',
                        text: 'La modalidad de admisión se registró correctamente.',
                        timer: 2000,
                        showConfirmButton: false
                    });

                    $('#modalNuevoTipo').modal('hide');
                    form[0].reset();

                    // Puedes recargar la tabla o hacer un fetch dinámico si lo prefieres
                    setTimeout(() => {
                        location.reload();
                    }, 2000);
                },
                error: function (xhr) {
                    let errores = xhr.responseJSON.errors;
                    let mensaje = 'Ocurrió un error al guardar.';

                    if (errores) {
                        mensaje = Object.values(errores).join('<br>');
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: mensaje
                    });
                }
            });
        });
    });
</script>
<!-- editar -->
<script>
    $(document).ready(function () {
        
        // Cargar datos en el modal
        $('#modalEditarTipo').on('show.bs.modal', function (event) {
            const button = $(event.relatedTarget);
            $('#edit_id').val(button.data('id'));
            $('#edit_nombre').val(button.data('nombre'));
            $('#edit_monto').val(button.data('monto'));
            $('#edit_monto_extemporaneo').val(button.data('extemporaneo'));
            
            

        });

        // Enviar el formulario por AJAX
        $('#formEditarTipoAdmision').on('submit', function (e) {
            e.preventDefault();

            const id = $('#edit_id').val();
            const url = `/tipo_admision/${id}`;
            const data = {
                _token: $('input[name="_token"]').val(),
                _method: 'PUT',
                nombre: $('#edit_nombre').val(),
                monto: $('#edit_monto').val(),
                monto_extemporaneo: $('#edit_monto_extemporaneo').val(),
                
            };

            $.ajax({
                url: url,
                method: 'POST',
                data: data,
                success: function (response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Actualizado',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        });

                        $('#modalEditarTipo').modal('hide');
                        setTimeout(() => location.reload(), 1000);
                    }
                },
                error: function (xhr) {
                    let mensaje = 'Error al actualizar.';
                    if (xhr.responseJSON && xhr.responseJSON.errors) {
                        mensaje = Object.values(xhr.responseJSON.errors).join('<br>');
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        html: mensaje
                    });
                }
            });
        });
    });
</script>
<!-- activar o desactivar -->
<script>
    $(document).on('change', '.toggle-estado', function () {
        const id = $(this).data('id');
        const estado = $(this).is(':checked') ? 1 : 0;

        $.ajax({
            url: `/tipo_admision/${id}/cambiar-estado`,
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                activo: estado
            },
            success: function (response) {
                // Cambiar texto al lado del switch dinámicamente
                const badge = $(`#estado-texto-${id}`);
                if (estado) {
                    badge.removeClass('badge-soft-warning').addClass('badge-soft-success').text('Activo');
                } else {
                    badge.removeClass('badge-soft-success').addClass('badge-soft-warning').text('Inactivo');
                }

                Swal.fire({
                    icon: 'success',
                    title: 'Actualizado',
                    text: response.message,
                    timer: 1500,
                    showConfirmButton: false
                });
            },
            error: function () {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'No se pudo cambiar el estado.'
                });
            }
        });
    });

</script>

<script>
    $(document).ready(function () {
        // Configuración para el botón de eliminar
        $('.delete-button').on('click', function () {
            var tipoId = $(this).data('id');
            var form = $('#form-delete-' + tipoId); // Seleccionar el formulario correspondiente

            // Mostrar confirmación con SweetAlert2
            Swal.fire({
                title: '¿Estás seguro?',
                text: "¡Este registro será eliminado permanentemente!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    // Realizar la solicitud AJAX si el usuario confirma
                    $.ajax({
                        url: form.attr('action'), // Obtener la URL del formulario
                        method: form.attr('method'), // Obtener el método del formulario
                        data: form.serialize(), // Enviar los datos del formulario
                        success: function (response) {
                            // Mostrar mensaje de éxito
                            Swal.fire(
                                'Eliminado!',
                                'El tipo de admisión ha sido eliminado.',
                                'success'
                            );
                            // Eliminar la fila de la tabla
                            form.closest('tr').fadeOut();
                        },
                        error: function (xhr, status, error) {
                            // Mostrar mensaje de error
                            Swal.fire(
                                'Error!',
                                'Hubo un problema al eliminar el registro.',
                                'error'
                            );
                        }
                    });
                }
            });
        });
    });


</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpsanpedro.dedu.pe/resources/views/tipo_admision/index.blade.php ENDPATH**/ ?>