<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'es_mx', version '5.0'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'endpoint API';
$string['action:explain_text:model'] = 'modelo de IA';
$string['action:explain_text:model_help'] = 'El modelo usado para explicar el texto proporcionado.';
$string['action:explain_text:systeminstruction'] = 'Instrucción del sistema';
$string['action:explain_text:systeminstruction_help'] = 'La instrucción es enviada al modelo de IA junto con el prompt del usuario. No se recomienda editar esta instrucción a menos que fuera absolutamente necesario.';
$string['action:generate_image:endpoint'] = 'endpoint de API';
$string['action:generate_image:model'] = 'Modelo de IA';
$string['action:generate_image:model_desc'] = 'El modelo usado para generar imágenes a partir de los prompts del usuario.';
$string['action:generate_image:model_help'] = 'El modelo utilizado para generar imágenes a partir de las indicaciones del usuario.';
$string['action:generate_text:endpoint'] = 'endpoint de API';
$string['action:generate_text:model'] = 'Modelo de IA';
$string['action:generate_text:model_desc'] = 'el modelo usado para generar la respuesta de texto.';
$string['action:generate_text:model_help'] = 'El modelo utilizado para generar la respuesta de texto.';
$string['action:generate_text:systeminstruction'] = 'Instrucción del sistema';
$string['action:generate_text:systeminstruction_desc'] = 'La instrucción es enviada al modelo de IA junto con el prompt del usuario.  No se recomienda editar esta instrucción a menos que sea absolutamente necesario.';
$string['action:generate_text:systeminstruction_help'] = 'Esta instrucción se envía al modelo de IA junto con el mensaje del usuario. No se recomienda editar esta instrucción a menos que sea absolutamente necesario.';
$string['action:summarise_text:endpoint'] = 'endpoint de API';
$string['action:summarise_text:model'] = 'Modelo de IA';
$string['action:summarise_text:model_desc'] = 'El modelo usado para resumir el texto proporcionado.';
$string['action:summarise_text:model_help'] = 'El modelo utilizado para resumir el texto proporcionado.';
$string['action:summarise_text:systeminstruction'] = 'Instrucción del sistema';
$string['action:summarise_text:systeminstruction_desc'] = 'La instrucción es enviada al modelo de IA junto con el prompt del usuario.  No se recomienda editar esta instrucción a menos que sea absolutamente necesario.';
$string['action:summarise_text:systeminstruction_help'] = 'Esta instrucción se envía al modelo de IA junto con el mensaje del usuario. No se recomienda editar esta instrucción a menos que sea absolutamente necesario.';
$string['apikey'] = 'Clave API de OpenAI';
$string['apikey_desc'] = 'Obtener una clave de <a href="https://platform.openai.com/account/api-keys">OpenAI Platform API keys</a>.';
$string['apikey_help'] = 'Obtén una clave de sus <a href="https://platform.openai.com/account/api-keys" target="_blank">claves de API de OpenAI</a>.';
$string['custom_model_name'] = 'Nombre del modelo personalizado';
$string['enableglobalratelimit'] = 'Configurar limitante de velocidad para todo el sitio';
$string['enableglobalratelimit_desc'] = 'Limitar el número de solicitudes que el proveedor OpenAI API puede recibir en todo el sitio cada hora.';
$string['enableuserratelimit'] = 'Configurar límite de velocidad de usuario';
$string['enableuserratelimit_desc'] = 'Limitar el número de solicitudes que cada usuario puede hacerle al proveedor OpenAI API cada hora.';
$string['extraparams'] = 'Parámetros adicionales';
$string['extraparams_help'] = 'Aquí se pueden configurar parámetros extra. Se admite el formato JSON. Por ejemplo:
<pre>
{
"temperature": 0.5,
"max_completion_tokens": 100
}
</pre>';
$string['globalratelimit'] = 'Número máximo de solicitudes para todo el sitio';
$string['globalratelimit_desc'] = 'El número de solicitudes por hora permitidas para todo el sitio.';
$string['invalidjson'] = 'Cadena JSON inválida';
$string['orgid'] = 'ID de organización OpenAI';
$string['orgid_desc'] = 'Ingrese su ID de organización OpenAI de su <a href="https://platform.openai.com/account/org-settings">Cuenta en la Plataforma OpenAI</a>.';
$string['orgid_help'] = 'Obtenga su ID de organización OpenAI de su <a href="https://platform.openai.com/account/org-settings" target="_blank">cuenta OpenAI</a>.';
$string['pluginname'] = 'Proveedor OpenAI API';
$string['privacy:metadata'] = 'El plugin de Proveedor OpenAI API no almacena ningún dato personal.';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Esta información se envía a la API de OpenAI para generar una respuesta. La configuración de su cuenta de OpenAI puede cambiar la forma en que OpenAI almacena y conserva estos datos. Este plugin no envía datos de usuario de forma explícita a OpenAI ni los almacena en Moodle LMS.';
$string['privacy:metadata:aiprovider_openai:model'] = 'El modelo usado para generar la respuesta.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'El número de imágenes usadas en la respuesta al generar imágenes.';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'El prompt del texto ingresado usado para generar la respuesta.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'El formato de la respuesta. Al generar imágenes.';
$string['settings'] = 'Configuraciones';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'La penalización de frecuencia ajusta la frecuencia con la que se repiten las palabras. Cuanto mayor sea la penalización, menos repeticiones habrá en el texto generado.';
$string['settings_help'] = 'Ajuste la configuración a continuación para personalizar cómo se envían las solicitudes a OpenAI.';
$string['settings_max_completion_tokens'] = 'max_completion_tokens';
$string['settings_max_completion_tokens_help'] = 'El número máximo de tokens a generar en la respuesta';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'El número máximo de tokens usados en el texto generado.';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'La penalización por presencia incentiva al modelo a usar palabras nuevas al aumentar la probabilidad de elegir palabras que no ha usado antes. Un valor más alto hace que el texto generado sea más diverso, mientras que un valor más bajo permite mayor repetición.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'top_p (muestreo de núcleo) determina cuántas palabras posibles se deben considerar. Un valor alto (p. ej., 0,9) significa que el modelo analiza más palabras, lo que aumenta la diversidad del texto generado.';
$string['userratelimit'] = 'Número máximo de solicitudes por usuario';
$string['userratelimit_desc'] = 'El número de solicitudes por hora permitidas por hora, por usuario.';
